/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.subdoc;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.kv.subdoc.multi.Lookup;
import com.couchbase.client.core.message.kv.subdoc.multi.LookupCommand;
import com.couchbase.client.core.message.kv.subdoc.multi.MultiLookupResponse;
import com.couchbase.client.core.message.kv.subdoc.multi.MultiResult;
import com.couchbase.client.core.message.kv.subdoc.multi.SubMultiLookupDocOptionsBuilder;
import com.couchbase.client.core.message.kv.subdoc.multi.SubMultiLookupRequest;
import com.couchbase.client.core.message.kv.subdoc.simple.SimpleSubdocResponse;
import com.couchbase.client.core.message.kv.subdoc.simple.SubExistRequest;
import com.couchbase.client.core.message.kv.subdoc.simple.SubGetCountRequest;
import com.couchbase.client.core.message.kv.subdoc.simple.SubGetRequest;
import com.couchbase.client.core.tracing.ThresholdLogSpan;
import com.couchbase.client.deps.io.netty.util.internal.StringUtil;
import com.couchbase.client.java.bucket.api.Utils;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.error.TranscodingException;
import com.couchbase.client.java.error.subdoc.XattrOrderingException;
import com.couchbase.client.java.subdoc.DocumentFragment;
import com.couchbase.client.java.subdoc.LookupSpec;
import com.couchbase.client.java.subdoc.SubdocHelper;
import com.couchbase.client.java.subdoc.SubdocOperationResult;
import com.couchbase.client.java.subdoc.SubdocOptionsBuilder;
import com.couchbase.client.java.transcoder.TranscoderUtils;
import com.couchbase.client.java.transcoder.subdoc.FragmentTranscoder;
import com.couchbase.client.java.util.OnSubscribeDeferAndWatch;
import io.opentracing.Scope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action0;
import rx.functions.Func0;
import rx.functions.Func1;

@InterfaceStability.Committed
@InterfaceAudience.Public
public class AsyncLookupInBuilder {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(AsyncLookupInBuilder.class);
    private final ClusterFacade core;
    private final CouchbaseEnvironment environment;
    private final String bucketName;
    private final FragmentTranscoder subdocumentTranscoder;
    private final String docId;
    private final List<LookupSpec> specs;
    private boolean includeRaw = false;
    private boolean accessDeleted;
    private final Func1<MultiResult<Lookup>, SubdocOperationResult<Lookup>> multiCoreResultToLookupResult = new Func1<MultiResult<Lookup>, SubdocOperationResult<Lookup>>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SubdocOperationResult<Lookup> call(MultiResult<Lookup> lookupResult) {
            String path = lookupResult.path();
            Lookup operation = (Lookup)lookupResult.operation();
            ResponseStatus status = lookupResult.status();
            boolean isExist = operation == Lookup.EXIST;
            boolean isGetCount = operation == Lookup.GET_COUNT;
            boolean isSuccess = status.isSuccess();
            boolean isNotFound = status == ResponseStatus.SUBDOC_PATH_NOT_FOUND;
            try {
                if (isExist && isSuccess) {
                    SubdocOperationResult<Lookup> subdocOperationResult = SubdocOperationResult.createResult(path, operation, status, true);
                    return subdocOperationResult;
                }
                if (isExist && isNotFound) {
                    SubdocOperationResult<Lookup> subdocOperationResult = SubdocOperationResult.createResult(path, operation, status, false);
                    return subdocOperationResult;
                }
                if (!isExist && isSuccess) {
                    byte[] raw;
                    block17: {
                        try {
                            if (isGetCount) {
                                long count = AsyncLookupInBuilder.this.subdocumentTranscoder.decode(lookupResult.value(), Long.class);
                                SubdocOperationResult<Lookup> subdocOperationResult = SubdocOperationResult.createResult(path, operation, status, count);
                                return subdocOperationResult;
                            }
                            raw = null;
                            if (!AsyncLookupInBuilder.this.isIncludeRaw()) break block17;
                        }
                        catch (TranscodingException e) {
                            LOGGER.error("Couldn't decode multi-lookup {} for {}/{}", new Object[]{RedactableArgument.user((Object)operation), RedactableArgument.user((Object)AsyncLookupInBuilder.this.docId), RedactableArgument.user((Object)path), e});
                            SubdocOperationResult<Lookup> subdocOperationResult = SubdocOperationResult.createFatal(path, operation, (RuntimeException)((Object)e));
                            return subdocOperationResult;
                        }
                        TranscoderUtils.ByteBufToArray rawData = TranscoderUtils.byteBufToByteArray(lookupResult.value());
                        raw = Arrays.copyOfRange(rawData.byteArray, rawData.offset, rawData.offset + rawData.length);
                    }
                    Object content = AsyncLookupInBuilder.this.subdocumentTranscoder.decode(lookupResult.value(), Object.class);
                    SubdocOperationResult<Lookup> subdocOperationResult = SubdocOperationResult.createResult(path, operation, status, content, raw);
                    return subdocOperationResult;
                }
                if (!isExist && isNotFound) {
                    SubdocOperationResult<Lookup> subdocOperationResult = SubdocOperationResult.createResult(path, operation, status, null);
                    return subdocOperationResult;
                }
                SubdocOperationResult<Lookup> subdocOperationResult = SubdocOperationResult.createError(path, operation, status, SubdocHelper.commonSubdocErrors(status, AsyncLookupInBuilder.this.docId, path));
                return subdocOperationResult;
            }
            finally {
                if (lookupResult.value() != null) {
                    lookupResult.value().release();
                }
            }
        }
    };

    @InterfaceAudience.Private
    public AsyncLookupInBuilder(ClusterFacade core, String bucketName, CouchbaseEnvironment environment, FragmentTranscoder transcoder, String docId) {
        if (docId == null || docId.isEmpty()) {
            throw new IllegalArgumentException("The document ID must not be null or empty.");
        }
        if (docId.getBytes().length > 250) {
            throw new IllegalArgumentException("The document ID must not be larger than 250 bytes");
        }
        this.core = core;
        this.bucketName = bucketName;
        this.environment = environment;
        this.subdocumentTranscoder = transcoder;
        this.docId = docId;
        this.specs = new ArrayList<LookupSpec>();
    }

    @InterfaceStability.Committed
    public AsyncLookupInBuilder accessDeleted(boolean accessDeleted) {
        this.accessDeleted = accessDeleted;
        return this;
    }

    public Observable<DocumentFragment<Lookup>> execute() {
        return this.execute(0L, null);
    }

    public Observable<DocumentFragment<Lookup>> execute(long timeout, TimeUnit timeUnit) {
        if (this.specs.isEmpty()) {
            throw new IllegalArgumentException("Execution of a subdoc lookup requires at least one operation");
        }
        if (this.specs.size() == 1) {
            return this.doSingleLookup(this.specs.get(0), timeout, timeUnit);
        }
        return this.doMultiLookup(timeout, timeUnit);
    }

    public AsyncLookupInBuilder includeRaw(boolean includeRaw) {
        this.includeRaw = includeRaw;
        return this;
    }

    public boolean isIncludeRaw() {
        return this.includeRaw;
    }

    public AsyncLookupInBuilder get(String ... paths) {
        if (paths == null || paths.length == 0) {
            throw new IllegalArgumentException("Path is mandatory for subdoc get");
        }
        for (String path : paths) {
            if (StringUtil.isNullOrEmpty((String)path)) {
                throw new IllegalArgumentException("Path is mandatory for subdoc get");
            }
            this.specs.add(new LookupSpec(Lookup.GET, path));
        }
        return this;
    }

    @InterfaceStability.Committed
    public AsyncLookupInBuilder get() {
        this.specs.add(new LookupSpec(Lookup.GETDOC, ""));
        return this;
    }

    public AsyncLookupInBuilder get(String path, SubdocOptionsBuilder optionsBuilder) {
        if (path == null) {
            throw new IllegalArgumentException("Path is mandatory for subdoc get");
        }
        if (optionsBuilder.createPath()) {
            throw new IllegalArgumentException("Options createPath are not supported for lookup");
        }
        this.specs.add(new LookupSpec(Lookup.GET, path, optionsBuilder));
        return this;
    }

    public AsyncLookupInBuilder get(Iterable<String> paths, SubdocOptionsBuilder optionsBuilder) {
        if (paths == null) {
            throw new IllegalArgumentException("Path is mandatory for subdoc get");
        }
        if (optionsBuilder.createPath()) {
            throw new IllegalArgumentException("Options createPath are not supported for lookup");
        }
        for (String path : paths) {
            if (StringUtil.isNullOrEmpty((String)path)) {
                throw new IllegalArgumentException("Path is mandatory for subdoc get");
            }
            this.specs.add(new LookupSpec(Lookup.GET, path, optionsBuilder));
        }
        return this;
    }

    public AsyncLookupInBuilder exists(String ... paths) {
        if (paths == null || paths.length == 0) {
            throw new IllegalArgumentException("Path is mandatory for subdoc exists");
        }
        for (String path : paths) {
            if (StringUtil.isNullOrEmpty((String)path)) {
                throw new IllegalArgumentException("Path is mandatory for subdoc exists");
            }
            this.specs.add(new LookupSpec(Lookup.EXIST, path));
        }
        return this;
    }

    public AsyncLookupInBuilder exists(String path, SubdocOptionsBuilder optionsBuilder) {
        if (path == null) {
            throw new IllegalArgumentException("Path is mandatory for subdoc exists");
        }
        if (optionsBuilder.createPath()) {
            throw new IllegalArgumentException("Options createPath are not supported for lookup");
        }
        this.specs.add(new LookupSpec(Lookup.EXIST, path, optionsBuilder));
        return this;
    }

    public AsyncLookupInBuilder exists(Iterable<String> paths, SubdocOptionsBuilder optionsBuilder) {
        if (paths == null) {
            throw new IllegalArgumentException("Path is mandatory for subdoc exists");
        }
        if (optionsBuilder.createPath()) {
            throw new IllegalArgumentException("Options createPath are not supported for lookup");
        }
        for (String path : paths) {
            if (StringUtil.isNullOrEmpty((String)path)) {
                throw new IllegalArgumentException("Path is mandatory for subdoc exists");
            }
            this.specs.add(new LookupSpec(Lookup.EXIST, path, optionsBuilder));
        }
        return this;
    }

    public AsyncLookupInBuilder getCount(String ... paths) {
        if (paths == null || paths.length == 0) {
            throw new IllegalArgumentException("Path is mandatory for subdoc get count");
        }
        for (String path : paths) {
            if (StringUtil.isNullOrEmpty((String)path)) {
                throw new IllegalArgumentException("Path is mandatory for subdoc get count");
            }
            this.specs.add(new LookupSpec(Lookup.GET_COUNT, path));
        }
        return this;
    }

    public AsyncLookupInBuilder getCount(String path, SubdocOptionsBuilder optionsBuilder) {
        if (path == null) {
            throw new IllegalArgumentException("Path is mandatory for subdoc get count");
        }
        if (optionsBuilder.createPath()) {
            throw new IllegalArgumentException("Options createPath are not supported for lookup");
        }
        this.specs.add(new LookupSpec(Lookup.GET_COUNT, path, optionsBuilder));
        return this;
    }

    public AsyncLookupInBuilder getCount(Iterable<String> paths, SubdocOptionsBuilder optionsBuilder) {
        if (paths == null) {
            throw new IllegalArgumentException("Path is mandatory for subdoc get count");
        }
        if (optionsBuilder.createPath()) {
            throw new IllegalArgumentException("Options createPath are not supported for lookup");
        }
        for (String path : paths) {
            if (StringUtil.isNullOrEmpty((String)path)) {
                throw new IllegalArgumentException("Path is mandatory for subdoc get count");
            }
            this.specs.add(new LookupSpec(Lookup.GET_COUNT, path, optionsBuilder));
        }
        return this;
    }

    protected Observable<DocumentFragment<Lookup>> doSingleLookup(LookupSpec spec, long timeout, TimeUnit timeUnit) {
        if (spec.lookup() == Lookup.GET) {
            return this.getIn(this.docId, spec, Object.class, timeout, timeUnit);
        }
        if (spec.lookup() == Lookup.EXIST) {
            return this.existsIn(this.docId, spec, timeout, timeUnit);
        }
        if (spec.lookup() == Lookup.GET_COUNT) {
            return this.getCountIn(this.docId, spec, timeout, timeUnit);
        }
        return Observable.error((Throwable)new UnsupportedOperationException("Lookup type " + spec.lookup() + " unknown"));
    }

    protected Observable<DocumentFragment<Lookup>> doMultiLookup(final long timeout, final TimeUnit timeUnit) {
        if (this.specs.isEmpty()) {
            throw new IllegalArgumentException("At least one Lookup Command is necessary for lookupIn");
        }
        boolean seenNonXattr = false;
        for (LookupSpec spec : this.specs) {
            if (spec.xattr() && seenNonXattr) {
                throw new XattrOrderingException("Xattr-based commands must always come first in the builder!");
            }
            if (spec.xattr()) continue;
            seenNonXattr = true;
        }
        final LookupSpec[] lookupSpecs = this.specs.toArray(new LookupSpec[this.specs.size()]);
        return Observable.defer((Func0)new Func0<Observable<DocumentFragment<Lookup>>>(){

            public Observable<DocumentFragment<Lookup>> call() {
                final SubMultiLookupRequest request = new SubMultiLookupRequest(AsyncLookupInBuilder.this.docId, AsyncLookupInBuilder.this.bucketName, SubMultiLookupDocOptionsBuilder.builder().accessDeleted(AsyncLookupInBuilder.this.accessDeleted), (LookupCommand[])lookupSpecs);
                Utils.addRequestSpan(AsyncLookupInBuilder.this.environment, (CouchbaseRequest)request, "subdoc_multi_lookup");
                return Utils.applyTimeout(OnSubscribeDeferAndWatch.deferAndWatch(new Func1<Subscriber, Observable<MultiLookupResponse>>(){

                    public Observable<MultiLookupResponse> call(Subscriber s) {
                        request.subscriber(s);
                        return AsyncLookupInBuilder.this.core.send((CouchbaseRequest)request);
                    }
                }).filter((Func1)new Func1<MultiLookupResponse, Boolean>(){

                    public Boolean call(MultiLookupResponse response) {
                        if (response.status().isSuccess() || response.status() == ResponseStatus.SUBDOC_MULTI_PATH_FAILURE) {
                            return true;
                        }
                        if (response.content() != null && response.content().refCnt() > 0) {
                            response.content().release();
                        }
                        throw SubdocHelper.commonSubdocErrors(response.status(), AsyncLookupInBuilder.this.docId, "MULTI-LOOKUP");
                    }
                }).flatMap((Func1)new Func1<MultiLookupResponse, Observable<DocumentFragment<Lookup>>>(){

                    public Observable<DocumentFragment<Lookup>> call(final MultiLookupResponse mlr) {
                        return Observable.from((Iterable)mlr.responses()).map(AsyncLookupInBuilder.this.multiCoreResultToLookupResult).toList().map((Func1)new Func1<List<SubdocOperationResult<Lookup>>, DocumentFragment<Lookup>>(){

                            public DocumentFragment<Lookup> call(List<SubdocOperationResult<Lookup>> lookupResults) {
                                return new DocumentFragment<Lookup>(AsyncLookupInBuilder.this.docId, mlr.cas(), null, lookupResults);
                            }
                        }).doOnTerminate(new Action0(){

                            public void call() {
                                if (AsyncLookupInBuilder.this.environment.operationTracingEnabled()) {
                                    AsyncLookupInBuilder.this.environment.tracer().scopeManager().activate(mlr.request().span(), true).close();
                                }
                            }
                        });
                    }
                }), (CouchbaseRequest)request, AsyncLookupInBuilder.this.environment, timeout, timeUnit);
            }
        });
    }

    private <T> Observable<DocumentFragment<Lookup>> getIn(final String id, final LookupSpec spec, final Class<T> fragmentType, long timeout, TimeUnit timeUnit) {
        return Observable.defer((Func0)new Func0<Observable<DocumentFragment<Lookup>>>(){

            public Observable<DocumentFragment<Lookup>> call() {
                final SubGetRequest request = new SubGetRequest(id, spec.path(), AsyncLookupInBuilder.this.bucketName);
                request.xattr(spec.xattr());
                request.accessDeleted(AsyncLookupInBuilder.this.accessDeleted);
                Utils.addRequestSpan(AsyncLookupInBuilder.this.environment, (CouchbaseRequest)request, "subdoc_get");
                return OnSubscribeDeferAndWatch.deferAndWatch(new Func1<Subscriber, Observable<SimpleSubdocResponse>>(){

                    public Observable<SimpleSubdocResponse> call(Subscriber s) {
                        request.subscriber(s);
                        return AsyncLookupInBuilder.this.core.send((CouchbaseRequest)request);
                    }
                }).map((Func1)new Func1<SimpleSubdocResponse, DocumentFragment<Lookup>>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public DocumentFragment<Lookup> call(SimpleSubdocResponse response) {
                        block15: {
                            if (!response.status().isSuccess()) break block15;
                            try {
                                byte[] raw = null;
                                if (AsyncLookupInBuilder.this.isIncludeRaw()) {
                                    TranscoderUtils.ByteBufToArray rawData = TranscoderUtils.byteBufToByteArray(response.content());
                                    raw = Arrays.copyOfRange(rawData.byteArray, rawData.offset, rawData.offset + rawData.length);
                                }
                                Scope decodeScope = null;
                                if (AsyncLookupInBuilder.this.environment.operationTracingEnabled()) {
                                    decodeScope = AsyncLookupInBuilder.this.environment.tracer().buildSpan("response_decoding").asChildOf(response.request().span()).startActive(true);
                                }
                                Object content = AsyncLookupInBuilder.this.subdocumentTranscoder.decodeWithMessage(response.content(), fragmentType, "Couldn't decode subget fragment for " + id + "/" + spec.path());
                                if (AsyncLookupInBuilder.this.environment.operationTracingEnabled() && decodeScope != null) {
                                    decodeScope.close();
                                    if (decodeScope.span() instanceof ThresholdLogSpan) {
                                        decodeScope.span().setBaggageItem("decode_us", Long.toString(((ThresholdLogSpan)decodeScope.span()).durationMicros()));
                                    }
                                }
                                SubdocOperationResult<Lookup> single = SubdocOperationResult.createResult(spec.path(), Lookup.GET, response.status(), content, raw);
                                DocumentFragment<Lookup> documentFragment = new DocumentFragment<Lookup>(id, response.cas(), response.mutationToken(), Collections.singletonList(single));
                                return documentFragment;
                            }
                            finally {
                                if (response.content() != null) {
                                    response.content().release();
                                }
                            }
                        }
                        if (response.content() != null && response.content().refCnt() > 0) {
                            response.content().release();
                        }
                        if (response.status() != ResponseStatus.SUBDOC_PATH_NOT_FOUND) throw SubdocHelper.commonSubdocErrors(response.status(), id, spec.path());
                        SubdocOperationResult<Lookup> single = SubdocOperationResult.createResult(spec.path(), Lookup.GET, response.status(), null);
                        return new DocumentFragment<Lookup>(id, response.cas(), response.mutationToken(), Collections.singletonList(single));
                        finally {
                            if (AsyncLookupInBuilder.this.environment.operationTracingEnabled()) {
                                AsyncLookupInBuilder.this.environment.tracer().scopeManager().activate(response.request().span(), true).close();
                            }
                        }
                    }
                });
            }
        });
    }

    private Observable<DocumentFragment<Lookup>> existsIn(final String id, final LookupSpec spec, final long timeout, final TimeUnit timeUnit) {
        return Observable.defer((Func0)new Func0<Observable<DocumentFragment<Lookup>>>(){

            public Observable<DocumentFragment<Lookup>> call() {
                final SubExistRequest request = new SubExistRequest(id, spec.path(), AsyncLookupInBuilder.this.bucketName);
                request.xattr(spec.xattr());
                request.accessDeleted(AsyncLookupInBuilder.this.accessDeleted);
                Utils.addRequestSpan(AsyncLookupInBuilder.this.environment, (CouchbaseRequest)request, "subdoc_exists");
                return Utils.applyTimeout(OnSubscribeDeferAndWatch.deferAndWatch(new Func1<Subscriber, Observable<SimpleSubdocResponse>>(){

                    public Observable<SimpleSubdocResponse> call(Subscriber s) {
                        request.subscriber(s);
                        return AsyncLookupInBuilder.this.core.send((CouchbaseRequest)request);
                    }
                }).map((Func1)new Func1<SimpleSubdocResponse, DocumentFragment<Lookup>>(){

                    public DocumentFragment<Lookup> call(SimpleSubdocResponse response) {
                        try {
                            if (response.content() != null && response.content().refCnt() > 0) {
                                response.content().release();
                            }
                            if (response.status().isSuccess()) {
                                SubdocOperationResult<Lookup> result = SubdocOperationResult.createResult(spec.path(), Lookup.EXIST, response.status(), true);
                                DocumentFragment<Lookup> documentFragment = new DocumentFragment<Lookup>(AsyncLookupInBuilder.this.docId, response.cas(), response.mutationToken(), Collections.singletonList(result));
                                return documentFragment;
                            }
                            if (response.status() == ResponseStatus.SUBDOC_PATH_NOT_FOUND) {
                                SubdocOperationResult<Lookup> result = SubdocOperationResult.createResult(spec.path(), Lookup.EXIST, response.status(), false);
                                DocumentFragment<Lookup> documentFragment = new DocumentFragment<Lookup>(AsyncLookupInBuilder.this.docId, response.cas(), response.mutationToken(), Collections.singletonList(result));
                                return documentFragment;
                            }
                            throw SubdocHelper.commonSubdocErrors(response.status(), id, spec.path());
                        }
                        finally {
                            if (AsyncLookupInBuilder.this.environment.operationTracingEnabled()) {
                                AsyncLookupInBuilder.this.environment.tracer().scopeManager().activate(response.request().span(), true).close();
                            }
                        }
                    }
                }), (CouchbaseRequest)request, AsyncLookupInBuilder.this.environment, timeout, timeUnit);
            }
        });
    }

    private Observable<DocumentFragment<Lookup>> getCountIn(final String id, final LookupSpec spec, final long timeout, final TimeUnit timeUnit) {
        return Observable.defer((Func0)new Func0<Observable<DocumentFragment<Lookup>>>(){

            public Observable<DocumentFragment<Lookup>> call() {
                final SubGetCountRequest request = new SubGetCountRequest(id, spec.path(), AsyncLookupInBuilder.this.bucketName);
                request.xattr(spec.xattr());
                request.accessDeleted(AsyncLookupInBuilder.this.accessDeleted);
                Utils.addRequestSpan(AsyncLookupInBuilder.this.environment, (CouchbaseRequest)request, "subdoc_count");
                return Utils.applyTimeout(OnSubscribeDeferAndWatch.deferAndWatch(new Func1<Subscriber, Observable<SimpleSubdocResponse>>(){

                    public Observable<SimpleSubdocResponse> call(Subscriber s) {
                        request.subscriber(s);
                        return AsyncLookupInBuilder.this.core.send((CouchbaseRequest)request);
                    }
                }).map((Func1)new Func1<SimpleSubdocResponse, DocumentFragment<Lookup>>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public DocumentFragment<Lookup> call(SimpleSubdocResponse response) {
                        block11: {
                            if (!response.status().isSuccess()) break block11;
                            try {
                                long count = AsyncLookupInBuilder.this.subdocumentTranscoder.decode(response.content(), Long.class);
                                SubdocOperationResult<Lookup> single = SubdocOperationResult.createResult(spec.path(), Lookup.GET_COUNT, response.status(), count);
                                DocumentFragment<Lookup> documentFragment = new DocumentFragment<Lookup>(id, response.cas(), response.mutationToken(), Collections.singletonList(single));
                                return documentFragment;
                            }
                            finally {
                                if (response.content() != null) {
                                    response.content().release();
                                }
                            }
                        }
                        if (response.content() != null && response.content().refCnt() > 0) {
                            response.content().release();
                        }
                        if (response.status() != ResponseStatus.SUBDOC_PATH_NOT_FOUND) throw SubdocHelper.commonSubdocErrors(response.status(), id, spec.path());
                        SubdocOperationResult<Lookup> single = SubdocOperationResult.createResult(spec.path(), Lookup.GET_COUNT, response.status(), null);
                        return new DocumentFragment<Lookup>(id, response.cas(), response.mutationToken(), Collections.singletonList(single));
                        finally {
                            if (AsyncLookupInBuilder.this.environment.operationTracingEnabled()) {
                                AsyncLookupInBuilder.this.environment.tracer().scopeManager().activate(response.request().span(), true).close();
                            }
                        }
                    }
                }), (CouchbaseRequest)request, AsyncLookupInBuilder.this.environment, timeout, timeUnit);
            }
        });
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("lookupIn(").append(this.docId).append(")[");
        int pos = sb.length();
        for (LookupSpec spec : this.specs) {
            sb.append(", ").append((Object)spec);
        }
        sb.delete(pos, pos + 2);
        sb.append(']');
        return sb.toString();
    }
}

