/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.collection;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.util.ReactorOps;
import com.couchbase.client.java.manager.collection.AsyncCollectionManager;
import com.couchbase.client.java.manager.collection.CollectionSpec;
import com.couchbase.client.java.manager.collection.CreateCollectionOptions;
import com.couchbase.client.java.manager.collection.CreateCollectionSettings;
import com.couchbase.client.java.manager.collection.CreateScopeOptions;
import com.couchbase.client.java.manager.collection.DropCollectionOptions;
import com.couchbase.client.java.manager.collection.DropScopeOptions;
import com.couchbase.client.java.manager.collection.GetAllScopesOptions;
import com.couchbase.client.java.manager.collection.GetScopeOptions;
import com.couchbase.client.java.manager.collection.ScopeSpec;
import com.couchbase.client.java.manager.collection.UpdateCollectionOptions;
import com.couchbase.client.java.manager.collection.UpdateCollectionSettings;
import java.util.Objects;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Stability.Volatile
public class ReactiveCollectionManager {
    private final AsyncCollectionManager async;
    private final ReactorOps reactor;

    @Stability.Internal
    public ReactiveCollectionManager(ReactorOps reactor, AsyncCollectionManager async) {
        this.reactor = Objects.requireNonNull(reactor);
        this.async = Objects.requireNonNull(async);
    }

    @Deprecated
    public Mono<Void> createCollection(CollectionSpec collectionSpec) {
        return this.createCollection(collectionSpec, CreateCollectionOptions.createCollectionOptions());
    }

    @Deprecated
    public Mono<Void> createCollection(CollectionSpec collectionSpec, CreateCollectionOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.async.createCollection(collectionSpec, options));
    }

    @Stability.Volatile
    public Mono<Void> createCollection(String scopeName, String collectionName, CreateCollectionSettings settings) {
        return this.reactor.publishOnUserScheduler(() -> this.async.createCollection(scopeName, collectionName, settings));
    }

    @Stability.Volatile
    public Mono<Void> createCollection(String scopeName, String collectionName, CreateCollectionSettings settings, CreateCollectionOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.async.createCollection(scopeName, collectionName, settings, options));
    }

    public Mono<Void> createScope(String scopeName) {
        return this.createScope(scopeName, CreateScopeOptions.createScopeOptions());
    }

    public Mono<Void> createScope(String scopeName, CreateScopeOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.async.createScope(scopeName, options));
    }

    @Stability.Volatile
    public Mono<Void> updateCollection(String scopeName, String collectionName, UpdateCollectionSettings settings) {
        return this.reactor.publishOnUserScheduler(() -> this.async.updateCollection(scopeName, collectionName, settings));
    }

    @Stability.Volatile
    public Mono<Void> updateCollection(String scopeName, String collectionName, UpdateCollectionSettings settings, UpdateCollectionOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.async.updateCollection(scopeName, collectionName, settings, options));
    }

    @Deprecated
    public Mono<Void> dropCollection(CollectionSpec collectionSpec) {
        return this.dropCollection(collectionSpec, DropCollectionOptions.dropCollectionOptions());
    }

    @Deprecated
    public Mono<Void> dropCollection(CollectionSpec collectionSpec, DropCollectionOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.async.dropCollection(collectionSpec, options));
    }

    @Stability.Volatile
    public Mono<Void> dropCollection(String scopeName, String collectionName) {
        return this.dropCollection(scopeName, collectionName, DropCollectionOptions.dropCollectionOptions());
    }

    @Stability.Volatile
    public Mono<Void> dropCollection(String scopeName, String collectionName, DropCollectionOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.async.dropCollection(scopeName, collectionName, options));
    }

    public Mono<Void> dropScope(String scopeName) {
        return this.dropScope(scopeName, DropScopeOptions.dropScopeOptions());
    }

    public Mono<Void> dropScope(String scopeName, DropScopeOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.async.dropScope(scopeName, options));
    }

    @Deprecated
    public Mono<ScopeSpec> getScope(String scopeName) {
        return this.getScope(scopeName, GetScopeOptions.getScopeOptions());
    }

    @Deprecated
    public Mono<ScopeSpec> getScope(String scopeName, GetScopeOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.async.getScope(scopeName, options));
    }

    public Flux<ScopeSpec> getAllScopes() {
        return this.getAllScopes(GetAllScopesOptions.getAllScopesOptions());
    }

    public Flux<ScopeSpec> getAllScopes(GetAllScopesOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.async.getAllScopes(options)).flatMapMany(Flux::fromIterable);
    }
}

