/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.transactions.config;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.core.transaction.config.CoreSingleQueryTransactionOptions;
import com.couchbase.client.core.transaction.support.TransactionAttemptContextFactory;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.Collection;
import java.util.Optional;

@Stability.Uncommitted
public class SingleQueryTransactionOptions {
    private Optional<DurabilityLevel> durabilityLevel = Optional.empty();
    private Optional<TransactionAttemptContextFactory> attemptContextFactory = Optional.empty();
    private Optional<CollectionIdentifier> metadataCollection = Optional.empty();

    public static SingleQueryTransactionOptions singleQueryTransactionOptions() {
        return new SingleQueryTransactionOptions();
    }

    @Stability.Internal
    public CoreSingleQueryTransactionOptions build() {
        return new CoreSingleQueryTransactionOptions(this.durabilityLevel, this.attemptContextFactory, this.metadataCollection);
    }

    public SingleQueryTransactionOptions durabilityLevel(DurabilityLevel durabilityLevel) {
        Validators.notNull((Object)durabilityLevel, (String)"durabilityLevel");
        this.durabilityLevel = Optional.of(durabilityLevel);
        return this;
    }

    @Stability.Internal
    SingleQueryTransactionOptions metadataCollection(Collection collection) {
        Validators.notNull((Object)collection, (String)"collection");
        CollectionIdentifier coll = new CollectionIdentifier(collection.bucketName(), Optional.of(collection.scopeName()), Optional.of(collection.name()));
        this.metadataCollection = Optional.of(coll);
        return this;
    }

    @Stability.Internal
    SingleQueryTransactionOptions testFactory(TransactionAttemptContextFactory attemptContextFactory) {
        this.attemptContextFactory = Optional.of(attemptContextFactory);
        return this;
    }
}

