/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.desc;

import dm.jdbc.desc.AbstractLob$LobCtl;
import dm.jdbc.desc.Column;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.filter.Filterable;
import dm.jdbc.util.ByteUtil;
import java.io.Serializable;

public abstract class AbstractLob
extends Filterable
implements Serializable {
    public static final byte LOB_FLAG_BYTE = 0;
    public static final byte LOB_FLAG_CHAR = 1;
    public static final byte LOB_IN_ROW = 1;
    public static final byte LOB_OFF_ROW = 2;
    public static final int NBLOB_HEAD_IN_ROW_FLAG = 0;
    public static final int NBLOB_HEAD_BLOBID = 1;
    public static final int NBLOB_HEAD_BLOB_LEN = 9;
    public static final int NBLOB_HEAD_OUTROW_GROUPID = 13;
    public static final int NBLOB_HEAD_OUTROW_FILEID = 15;
    public static final int NBLOB_HEAD_OUTROW_PAGENO = 17;
    public static final int NBLOB_EX_HEAD_TABLE_ID = 21;
    public static final int NBLOB_EX_HEAD_COL_ID = 25;
    public static final int NBLOB_EX_HEAD_ROW_ID = 27;
    public static final int NBLOB_EX_HEAD_FPA_GRPID = 35;
    public static final int NBLOB_EX_HEAD_FPA_FILEID = 37;
    public static final int NBLOB_EX_HEAD_FPA_PAGENO = 39;
    public static final int NBLOB_EX_HEAD_SIZE = 43;
    public static final int NBLOB_OUTROW_HEAD_SIZE = 21;
    public static final int NBLOB_INROW_HEAD_SIZE = 13;
    public long id;
    public boolean inRow = true;
    public int groupId = -1;
    public int fileId = -1;
    public int pageNo = -1;
    public int tabId;
    public int colId;
    public long rowId;
    public short exGroupId;
    public short exFileId;
    public int exPageNo;
    public int curFileId;
    public int curPageNo;
    public short curPageOffset;
    public int totalOffset;
    public boolean readOver = false;
    public DmdbConnection connection;
    public boolean local = true;
    public boolean updateable = true;
    public byte lobFlag;
    public long bytesLength = -1L;
    public long length = -1L;
    public boolean compatibleOracle = false;
    public boolean fetchAll = false;
    public boolean freed = false;
    public boolean modify = false;

    public AbstractLob(byte[] byArray, byte by, DmdbConnection dmdbConnection, Column column) {
        this(by, dmdbConnection);
        this.lobFlag = by;
        this.bytesLength = ByteUtil.getInt(byArray, 9);
        this.compatibleOracle = dmdbConnection.compatibleOracle();
        this.local = false;
        this.updateable = !column.readonly;
        this.tabId = column.lobTabId;
        this.colId = column.lobColId;
        this.inRow = ByteUtil.getByte(byArray, 0) == 1;
        this.id = ByteUtil.getLong(byArray, 1);
        if (!this.inRow) {
            this.groupId = ByteUtil.getShort(byArray, 13);
            this.fileId = ByteUtil.getShort(byArray, 15);
            this.pageNo = ByteUtil.getInt(byArray, 17);
        }
        if (dmdbConnection.newLobFlag) {
            this.tabId = ByteUtil.getInt(byArray, 21);
            this.colId = ByteUtil.getShort(byArray, 25);
            this.rowId = ByteUtil.getLong(byArray, 27);
            this.exGroupId = ByteUtil.getShort(byArray, 35);
            this.exFileId = ByteUtil.getShort(byArray, 37);
            this.exPageNo = ByteUtil.getInt(byArray, 39);
        }
        this.resetCurrentInfo();
    }

    public void resetCurrentInfo() {
        this.curFileId = this.fileId;
        this.curPageNo = this.pageNo;
        this.totalOffset = 0;
        this.curPageOffset = 0;
    }

    public AbstractLob(byte by, DmdbConnection dmdbConnection) {
        super(dmdbConnection, null);
        this.connection = dmdbConnection;
        this.lobFlag = by;
    }

    protected abstract void loadAllData();

    public long do_length() {
        this.checkFreed();
        if (this.length == -1L) {
            this.connection.checkClosed();
            this.length = this.connection.dbAccess.a(this);
        }
        return this.length;
    }

    public void do_free() {
        this.connection = null;
        this.freed = true;
    }

    public void checkFreed() {
        if (this.freed) {
            DBError.ECJDBC_LOB_FREED.throwException(new String[0]);
        }
    }

    protected void checkConnection() {
        if (this.connection == null) {
            DBError.ECJDBC_LOB_FREED.throwException(new String[0]);
        }
    }

    public boolean canOptimized(DmdbConnection dmdbConnection) {
        return !this.inRow && !this.fetchAll && !this.local && !this.modify && dmdbConnection == this.connection;
    }

    public AbstractLob$LobCtl buildCtlData() {
        return new AbstractLob$LobCtl(this);
    }
}

