/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.desc;

import dm.jdbc.desc.DmProperties;
import dm.jdbc.desc.EPGroup$EPSelector;
import dm.jdbc.desc.EPGroup$HeadFirstSelector;
import dm.jdbc.desc.EPGroup$WellDistributeSelector;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.filter.log.ILogger;
import dm.jdbc.filter.log.LogFactory;
import dm.jdbc.util.MiscUtil;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;

public class EPGroup
implements Serializable {
    private static ILogger log = LogFactory.getLog(EPGroup.class);
    public String name;
    public List epList = null;
    public DmProperties props;
    public AtomicLong sessCount = new AtomicLong(0L);
    public static final int CLUSTER_TYPE_NORMAL = 0;
    public static final int CLUSTER_TYPE_RW = 1;
    public static final int CLUSTER_TYPE_DW = 2;
    public static final int CLUSTER_TYPE_DSC = 3;
    public static final int CLUSTER_TYPE_MPP = 4;
    public int epStartPos = -1;
    public ReentrantLock lock = new ReentrantLock();

    public EPGroup(String string, List list) {
        this.name = string;
        this.epList = list;
        this.epStartPos = list == null || list.size() == 0 ? -1 : new Random().nextInt(list.size()) - 1;
    }

    public void connect(DmdbConnection dmdbConnection) {
        SQLException sQLException = null;
        EPGroup$EPSelector ePGroup$EPSelector = dmdbConnection.epSelector == 1 ? new EPGroup$HeadFirstSelector(this) : new EPGroup$WellDistributeSelector(this);
        int n2 = this.epList.size() == 1 ? 1 : dmdbConnection.switchTimes + 1;
        int n3 = 0;
        while (n3 < n2) {
            if (n3 != 0) {
                MiscUtil.sleep(dmdbConnection.switchInterval);
            }
            log.debug("try connect loop " + n3);
            try {
                ePGroup$EPSelector.select(dmdbConnection, n3 == 0, n3 == n2 - 1);
                this.sessCount.incrementAndGet();
                return;
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
                ++n3;
            }
        }
        throw sQLException;
    }

    public void decrementSession() {
        this.sessCount.decrementAndGet();
    }

    static /* synthetic */ ILogger access$0() {
        return log;
    }
}

