/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter;

import dm.jdbc.desc.Configuration;
import dm.jdbc.desc.DmProperties;
import dm.jdbc.desc.DmSvcConf;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.filter.Filter;
import dm.jdbc.filter.FilterChain;
import dm.jdbc.filter.Filterable$FldrInfo;
import dm.jdbc.filter.Filterable$LogInfo;
import dm.jdbc.filter.Filterable$RWInfo;
import dm.jdbc.filter.Filterable$RecoverInfo;
import dm.jdbc.filter.Filterable$StatInfo;
import dm.jdbc.filter.fldr.FldrFilter;
import dm.jdbc.filter.log.LogFilter;
import dm.jdbc.filter.reconnect.ReconnectFilter;
import dm.jdbc.filter.stat.StatFilter;
import dm.jdbc.rw.RWFilter;
import dm.jdbc.rw.RWFilter2;
import java.util.ArrayList;
import java.util.List;

public abstract class Filterable {
    protected FilterChain filterChain = null;
    public Filterable$RWInfo rwInfo = null;
    public Filterable$LogInfo logInfo = null;
    public Filterable$StatInfo statInfo = null;
    public Filterable$FldrInfo fldrInfo = null;
    public Filterable$RecoverInfo recoverInfo = null;
    protected long ID = -1L;

    public abstract long getID();

    public Filterable(DmdbConnection dmdbConnection, DmProperties dmProperties) {
        this.filterChain = this.createFilterChain(dmdbConnection, dmProperties);
    }

    public FilterChain createFilterChain(DmdbConnection dmdbConnection, DmProperties dmProperties) {
        FilterChain filterChain = null;
        List list = null;
        if (dmdbConnection != null) {
            if (DmSvcConf.GLOBAL.logLevel != 0) {
                list = list == null ? new ArrayList() : list;
                list.add(LogFilter.getInstance());
                this.logInfo = new Filterable$LogInfo(this);
            }
            if (DmSvcConf.GLOBAL.statEnable) {
                list = list == null ? new ArrayList() : list;
                list.add(StatFilter.getInstance());
                this.statInfo = new Filterable$StatInfo(this);
            }
            if (dmdbConnection.doSwitch != 0) {
                list = list == null ? new ArrayList() : list;
                list.add(ReconnectFilter.getInstance());
                this.recoverInfo = new Filterable$RecoverInfo(this);
            }
            if (dmdbConnection.mppOpt > 0) {
                list = list == null ? new ArrayList() : list;
                list.add(FldrFilter.getInstance());
            }
            if (dmdbConnection.rwSeparate) {
                list = list == null ? new ArrayList() : list;
                list.add(dmdbConnection.rwFilterType == 2 ? RWFilter2.getInstance() : RWFilter.getInstance());
                this.rwInfo = new Filterable$RWInfo(this);
            }
        } else if (dmProperties != null) {
            if (Configuration.parseLogLevel(dmProperties) != 0) {
                list = list == null ? new ArrayList() : list;
                list.add(LogFilter.getInstance());
                this.logInfo = new Filterable$LogInfo(this);
            }
            if (dmProperties.getBoolean(Configuration.statEnable)) {
                list = list == null ? new ArrayList() : list;
                list.add(StatFilter.getInstance());
                this.statInfo = new Filterable$StatInfo(this);
            }
            if (dmProperties.getInt(Configuration.doSwitch) != 0) {
                list = list == null ? new ArrayList() : list;
                list.add(ReconnectFilter.getInstance());
                this.recoverInfo = new Filterable$RecoverInfo(this);
            }
            if (dmProperties.getInt(Configuration.mppOpt) > 0) {
                list = list == null ? new ArrayList() : list;
                list.add(FldrFilter.getInstance());
            }
            if (dmProperties.getBoolean(Configuration.rwSeparate)) {
                list = list == null ? new ArrayList() : list;
                list.add(dmProperties.getInt(Configuration.rwFilterType) == 2 ? RWFilter2.getInstance() : RWFilter.getInstance());
                this.rwInfo = new Filterable$RWInfo(this);
            }
        }
        if (list != null && list.size() > 0) {
            filterChain = new FilterChain(list.toArray(new Filter[0]));
        }
        return filterChain;
    }
}

