/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.mapping;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.UserType;
import com.datastax.driver.mapping.AliasedMappedProperty;
import com.datastax.driver.mapping.MappingManager;
import com.datastax.driver.mapping.ReflectionUtils;
import java.nio.ByteBuffer;
import java.util.Map;

class MappedUDTCodec<T>
extends TypeCodec.AbstractUDTCodec<T> {
    private final UserType cqlUserType;
    private final Class<T> udtClass;
    private final Map<String, AliasedMappedProperty> columnMappers;
    private final CodecRegistry codecRegistry;

    MappedUDTCodec(UserType cqlUserType, Class<T> udtClass, Map<String, AliasedMappedProperty> columnMappers, MappingManager mappingManager) {
        super(cqlUserType, udtClass);
        this.cqlUserType = cqlUserType;
        this.udtClass = udtClass;
        this.columnMappers = columnMappers;
        this.codecRegistry = mappingManager.getSession().getCluster().getConfiguration().getCodecRegistry();
    }

    protected T newInstance() {
        return ReflectionUtils.newInstance(this.udtClass);
    }

    Class<T> getUdtClass() {
        return this.udtClass;
    }

    protected ByteBuffer serializeField(T source, String fieldName, ProtocolVersion protocolVersion) {
        AliasedMappedProperty aliasedMappedProperty = this.columnMappers.get(fieldName);
        if (aliasedMappedProperty == null) {
            return null;
        }
        Object value = aliasedMappedProperty.mappedProperty.getValue(source);
        TypeCodec codec = aliasedMappedProperty.mappedProperty.getCustomCodec();
        if (codec == null) {
            codec = this.codecRegistry.codecFor(this.cqlUserType.getFieldType(aliasedMappedProperty.mappedProperty.getMappedName()), aliasedMappedProperty.mappedProperty.getPropertyType());
        }
        return codec.serialize(value, protocolVersion);
    }

    protected T deserializeAndSetField(ByteBuffer input, T target, String fieldName, ProtocolVersion protocolVersion) {
        AliasedMappedProperty aliasedMappedProperty = this.columnMappers.get(fieldName);
        if (aliasedMappedProperty != null) {
            TypeCodec codec = aliasedMappedProperty.mappedProperty.getCustomCodec();
            if (codec == null) {
                codec = this.codecRegistry.codecFor(this.cqlUserType.getFieldType(aliasedMappedProperty.mappedProperty.getMappedName()), aliasedMappedProperty.mappedProperty.getPropertyType());
            }
            aliasedMappedProperty.mappedProperty.setValue(target, codec.deserialize(input, protocolVersion));
        }
        return target;
    }

    protected String formatField(T source, String fieldName) {
        AliasedMappedProperty aliasedMappedProperty = this.columnMappers.get(fieldName);
        if (aliasedMappedProperty == null) {
            return null;
        }
        Object value = aliasedMappedProperty.mappedProperty.getValue(source);
        TypeCodec codec = aliasedMappedProperty.mappedProperty.getCustomCodec();
        if (codec == null) {
            codec = this.codecRegistry.codecFor(this.cqlUserType.getFieldType(aliasedMappedProperty.mappedProperty.getMappedName()), aliasedMappedProperty.mappedProperty.getPropertyType());
        }
        return codec.format(value);
    }

    protected T parseAndSetField(String input, T target, String fieldName) {
        AliasedMappedProperty aliasedMappedProperty = this.columnMappers.get(fieldName);
        if (aliasedMappedProperty != null) {
            TypeCodec codec = aliasedMappedProperty.mappedProperty.getCustomCodec();
            if (codec == null) {
                codec = this.codecRegistry.codecFor(this.cqlUserType.getFieldType(aliasedMappedProperty.mappedProperty.getMappedName()), aliasedMappedProperty.mappedProperty.getPropertyType());
            }
            aliasedMappedProperty.mappedProperty.setValue(target, codec.parse(input));
        }
        return target;
    }
}

