/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra;

import com.diffplug.common.base.Errors;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.SystemReader;

public final class GitWorkarounds {
    private GitWorkarounds() {
    }

    @Nullable
    static File getDotGitDir(File projectDir) {
        return GitWorkarounds.fileRepositoryResolverForProject(projectDir).getGitDir();
    }

    static RepositorySpecificResolver fileRepositoryResolverForProject(File projectDir) {
        return GitWorkarounds.fileRepositoryResolverForProject(projectDir, null);
    }

    static RepositorySpecificResolver fileRepositoryResolverForProject(File projectDir, @Nullable Config baseConfig) {
        RepositorySpecificResolver repositoryResolver;
        block3: {
            block2: {
                repositoryResolver = new RepositorySpecificResolver(baseConfig);
                repositoryResolver.findGitDir(projectDir);
                repositoryResolver.readEnvironment();
                if (repositoryResolver.getGitDir() != null) break block2;
                if (repositoryResolver.getWorkTree() == null) break block3;
            }
            Errors.rethrow().get(() -> ((RepositorySpecificResolver)repositoryResolver).setup());
        }
        return repositoryResolver;
    }

    static class RepositorySpecificResolver
    extends FileRepositoryBuilder {
        private static final String COMMON_DIR = "commondir";
        private static final String GIT_COMMON_DIR_ENV_KEY = "GIT_COMMON_DIR";
        private static final String EXTENSIONS_WORKTREE_CONFIG = "worktreeConfig";
        private static final String EXTENSIONS_WORKTREE_CONFIG_FILENAME = "config.worktree";
        private File commonDirectory;
        private Config baseConfig;

        public RepositorySpecificResolver() {
            this(null);
        }

        public RepositorySpecificResolver(@Nullable Config baseConfig) {
            this.baseConfig = baseConfig;
        }

        Config getRepositoryConfig() {
            return (Config)Errors.rethrow().get(() -> this.getConfig());
        }

        protected Config loadConfig() throws IOException {
            if (this.getGitDir() != null) {
                FileBasedConfig cfg;
                block5: {
                    File path = this.resolveWithCommonDir("config");
                    cfg = null;
                    cfg = this.baseConfig == null ? new FileBasedConfig(path, this.safeFS()) : new FileBasedConfig(this.baseConfig, path, this.safeFS());
                    try {
                        cfg.load();
                        if (!cfg.getBoolean("extensions", EXTENSIONS_WORKTREE_CONFIG, false)) break block5;
                        File worktreeSpecificConfig = this.safeFS().resolve(this.getGitDir(), EXTENSIONS_WORKTREE_CONFIG_FILENAME);
                        if (!this.safeFS().exists(worktreeSpecificConfig) || !this.safeFS().isFile(worktreeSpecificConfig)) break block5;
                        cfg = new FileBasedConfig((Config)cfg, worktreeSpecificConfig, this.safeFS());
                        try {
                            cfg.load();
                        }
                        catch (ConfigInvalidException err) {
                            throw new IllegalArgumentException("Failed to parse config " + worktreeSpecificConfig.getAbsolutePath(), err);
                        }
                    }
                    catch (ConfigInvalidException err) {
                        throw new IllegalArgumentException("Failed to parse config " + path.getAbsolutePath(), err);
                    }
                }
                return cfg;
            }
            return super.loadConfig();
        }

        protected void setupGitDir() throws IOException {
            super.setupGitDir();
            if (this.commonDirectory == null) {
                File commonDirFile = this.safeFS().resolve(this.getGitDir(), COMMON_DIR);
                if (this.safeFS().exists(commonDirFile) && this.safeFS().isFile(commonDirFile)) {
                    byte[] content = IO.readFully((File)commonDirFile);
                    if (content.length < 1) {
                        throw RepositorySpecificResolver.emptyFile(commonDirFile);
                    }
                    int lineEnd = RawParseUtils.nextLF((byte[])content, (int)0);
                    while (content[lineEnd - 1] == 10 || content[lineEnd - 1] == 13 && SystemReader.getInstance().isWindows()) {
                        --lineEnd;
                    }
                    if (lineEnd <= 1) {
                        throw RepositorySpecificResolver.emptyFile(commonDirFile);
                    }
                    String commonPath = RawParseUtils.decode((byte[])content, (int)0, (int)lineEnd);
                    File common = new File(commonPath);
                    this.commonDirectory = common.isAbsolute() ? common : this.safeFS().resolve(this.getGitDir(), commonPath).getCanonicalFile();
                }
            }
            if (this.getObjectDirectory() == null) {
                this.setObjectDirectory(this.resolveWithCommonDir("objects"));
            }
        }

        private static IOException emptyFile(File commonDir) {
            return new IOException("Empty 'commondir' file: " + commonDir.getAbsolutePath());
        }

        @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"})
        public FileRepositoryBuilder readEnvironment(SystemReader sr) {
            super.readEnvironment(sr);
            String val = sr.getenv(GIT_COMMON_DIR_ENV_KEY);
            if (val != null) {
                this.commonDirectory = new File(val);
            }
            return (FileRepositoryBuilder)this.self();
        }

        File resolveWithCommonDir(String target) {
            if (this.commonDirectory != null) {
                return this.safeFS().resolve(this.commonDirectory, target);
            }
            return this.safeFS().resolve(this.getGitDir(), target);
        }
    }
}

