/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.common.api;

import com.alibaba.fastjson.JSON;
import com.egzosn.pay.common.api.Callback;
import com.egzosn.pay.common.api.DefaultPayMessageHandler;
import com.egzosn.pay.common.api.PayConfigStorage;
import com.egzosn.pay.common.api.PayMessageHandler;
import com.egzosn.pay.common.api.PayMessageInterceptor;
import com.egzosn.pay.common.api.PayService;
import com.egzosn.pay.common.bean.MethodType;
import com.egzosn.pay.common.bean.PayMessage;
import com.egzosn.pay.common.bean.PayOrder;
import com.egzosn.pay.common.bean.PayOutMessage;
import com.egzosn.pay.common.bean.RefundOrder;
import com.egzosn.pay.common.bean.TransactionType;
import com.egzosn.pay.common.bean.TransferOrder;
import com.egzosn.pay.common.http.HttpConfigStorage;
import com.egzosn.pay.common.http.HttpRequestTemplate;
import com.egzosn.pay.common.util.MatrixToImageWriter;
import com.egzosn.pay.common.util.sign.SignUtils;
import com.egzosn.pay.common.util.sign.encrypt.Base64;
import com.egzosn.pay.common.util.str.StringUtils;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BasePayService<PC extends PayConfigStorage>
implements PayService<PC> {
    protected final Log LOG = LogFactory.getLog(this.getClass());
    protected PC payConfigStorage;
    protected HttpRequestTemplate requestTemplate;
    protected int retrySleepMillis = 1000;
    protected int maxRetryTimes = 5;
    protected PayMessageHandler handler;
    protected List<PayMessageInterceptor> interceptors = new ArrayList<PayMessageInterceptor>();

    @Override
    public BasePayService setPayConfigStorage(PC payConfigStorage) {
        this.payConfigStorage = payConfigStorage;
        return this;
    }

    @Override
    public PC getPayConfigStorage() {
        return this.payConfigStorage;
    }

    @Override
    public HttpRequestTemplate getHttpRequestTemplate() {
        return this.requestTemplate;
    }

    @Override
    public BasePayService setRequestTemplateConfigStorage(HttpConfigStorage configStorage) {
        this.requestTemplate = new HttpRequestTemplate(configStorage);
        return this;
    }

    public BasePayService(PC payConfigStorage) {
        this(payConfigStorage, null);
    }

    public BasePayService(PC payConfigStorage, HttpConfigStorage configStorage) {
        this.setPayConfigStorage((PayConfigStorage)payConfigStorage);
        this.setRequestTemplateConfigStorage(configStorage);
    }

    protected String authorizationString(String user, String password) {
        String base64ClientID = null;
        try {
            base64ClientID = Base64.encode(String.format("%s:%s", user, password).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            this.LOG.error((Object)e);
        }
        return base64ClientID;
    }

    @Override
    public String createSign(String content, String characterEncoding) {
        return SignUtils.valueOf(this.payConfigStorage.getSignType()).createSign(content, this.payConfigStorage.getKeyPrivate(), characterEncoding);
    }

    @Override
    public String createSign(Map<String, Object> content, String characterEncoding) {
        return SignUtils.valueOf(this.payConfigStorage.getSignType()).sign(content, this.payConfigStorage.getKeyPrivate(), characterEncoding);
    }

    @Override
    public <O extends PayOrder> String toPay(O order) {
        Map<String, Object> orderInfo = this.orderInfo(order);
        return this.buildRequest(orderInfo, MethodType.POST);
    }

    @Override
    public <O extends PayOrder> BufferedImage genQrPay(O order) {
        return MatrixToImageWriter.writeInfoToJpgBuff(this.getQrPay(order));
    }

    @Override
    public Map<String, Object> getParameter2Map(Map<String, String[]> parameterMap, InputStream is) {
        TreeMap<String, Object> params = new TreeMap<String, Object>();
        for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
            String name = entry.getKey();
            String[] values = entry.getValue();
            String valueStr = "";
            int len = values.length;
            for (int i = 0; i < len; ++i) {
                valueStr = valueStr + (i == len - 1 ? values[i] : values[i] + ",");
            }
            if (StringUtils.isNotEmpty(this.payConfigStorage.getInputCharset()) && !valueStr.matches("\\w+")) {
                try {
                    if (valueStr.equals(new String(valueStr.getBytes("iso8859-1"), "iso8859-1"))) {
                        valueStr = new String(valueStr.getBytes("iso8859-1"), this.payConfigStorage.getInputCharset());
                    }
                }
                catch (UnsupportedEncodingException e) {
                    this.LOG.error((Object)e);
                }
            }
            params.put(name, valueStr);
        }
        return params;
    }

    @Override
    public <T> T query(String tradeNo, String outTradeNo, Callback<T> callback) {
        return callback.perform(this.query(tradeNo, outTradeNo));
    }

    @Override
    public <T> T close(String tradeNo, String outTradeNo, Callback<T> callback) {
        return callback.perform(this.close(tradeNo, outTradeNo));
    }

    @Override
    public <T> T cancel(String tradeNo, String outTradeNo, Callback<T> callback) {
        return callback.perform(this.close(tradeNo, outTradeNo));
    }

    @Override
    public Map<String, Object> cancel(String tradeNo, String outTradeNo) {
        return Collections.EMPTY_MAP;
    }

    @Override
    @Deprecated
    public <T> T refund(String tradeNo, String outTradeNo, BigDecimal refundAmount, BigDecimal totalAmount, Callback<T> callback) {
        return callback.perform(this.refund(new RefundOrder(tradeNo, outTradeNo, refundAmount, totalAmount)));
    }

    @Override
    public <T> T refund(RefundOrder refundOrder, Callback<T> callback) {
        return callback.perform(this.refund(refundOrder));
    }

    @Override
    public <T> T refundquery(String tradeNo, String outTradeNo, Callback<T> callback) {
        return callback.perform(this.refundquery(tradeNo, outTradeNo));
    }

    @Override
    public <T> T refundquery(RefundOrder refundOrder, Callback<T> callback) {
        return callback.perform(this.refundquery(refundOrder));
    }

    @Override
    public <T> T downloadbill(Date billDate, String billType, Callback<T> callback) {
        return callback.perform(this.downloadbill(billDate, billType));
    }

    @Override
    public <T> T secondaryInterface(Object tradeNoOrBillDate, String outTradeNoBillType, TransactionType transactionType, Callback<T> callback) {
        return callback.perform(this.secondaryInterface(tradeNoOrBillDate, outTradeNoBillType, transactionType));
    }

    @Override
    public <T> T transfer(TransferOrder order, Callback<T> callback) {
        return callback.perform(this.transfer(order));
    }

    @Override
    public Map<String, Object> transfer(TransferOrder order) {
        return new HashMap<String, Object>(0);
    }

    @Override
    public Map<String, Object> transferQuery(String outNo, String tradeNo) {
        return new HashMap<String, Object>(0);
    }

    @Override
    public <T> T transferQuery(String outNo, String tradeNo, Callback<T> callback) {
        return callback.perform(this.transferQuery(outNo, tradeNo));
    }

    @Override
    public void setPayMessageHandler(PayMessageHandler handler) {
        this.handler = handler;
    }

    public PayMessageHandler getPayMessageHandler() {
        if (null == this.handler) {
            this.setPayMessageHandler(new DefaultPayMessageHandler());
        }
        return this.handler;
    }

    @Override
    public void addPayMessageInterceptor(PayMessageInterceptor interceptor) {
        this.interceptors.add(interceptor);
    }

    @Override
    public PayOutMessage payBack(Map<String, String[]> parameterMap, InputStream is) {
        Map<String, Object> data = this.getParameter2Map(parameterMap, is);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("\u56de\u8c03\u54cd\u5e94:" + JSON.toJSONString(data)));
        }
        if (!this.verify(data)) {
            return this.getPayOutMessage("fail", "\u5931\u8d25");
        }
        PayMessage payMessage = this.createMessage(data);
        HashMap<String, Object> context = new HashMap<String, Object>();
        for (PayMessageInterceptor interceptor : this.interceptors) {
            if (interceptor.intercept(payMessage, context, this)) continue;
            return this.successPayOutMessage(payMessage);
        }
        return this.getPayMessageHandler().handle(payMessage, context, this);
    }

    @Override
    public PayMessage createMessage(Map<String, Object> message) {
        return new PayMessage(message);
    }

    @Override
    public <O extends PayOrder> Map<String, Object> preOrderHandler(Map<String, Object> orderInfo, O payOrder) {
        return orderInfo;
    }
}

