/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.common.bean;

import com.egzosn.pay.common.api.CertStore;
import com.egzosn.pay.common.http.HttpRequestTemplate;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public enum CertStoreType implements CertStore
{
    PATH{

        @Override
        public InputStream getInputStream(Object cert) throws IOException {
            return new FileInputStream(new File((String)cert));
        }
    }
    ,
    STR{

        @Override
        public InputStream getInputStream(Object cert) throws IOException {
            return new ByteArrayInputStream(((String)cert).getBytes("ISO-8859-1"));
        }
    }
    ,
    INPUT_STREAM{

        @Override
        public InputStream getInputStream(Object cert) throws IOException {
            return (InputStream)cert;
        }
    }
    ,
    URL{

        @Override
        public InputStream getInputStream(Object url) throws IOException {
            return new HttpRequestTemplate().getForObject((String)url, InputStream.class, new Object[0]);
        }
    }
    ,
    BEAN{

        @Override
        public InputStream getInputStream(Object beanClazz) throws IOException {
            try {
                Class<?> clazz = Class.forName((String)beanClazz);
                CertStore certStore = (CertStore)clazz.newInstance();
                return certStore.getInputStream(beanClazz);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            return null;
        }
    };

}

