/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.egzosn.pay.common.bean.result.PayException;
import com.egzosn.pay.common.exception.PayErrorException;
import com.egzosn.pay.common.util.str.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XML {
    public static JSONObject toJSONObject(InputStream in) {
        if (null == in) {
            return null;
        }
        try {
            return (JSONObject)XML.inputStream2Map(in, null);
        }
        catch (IOException e) {
            throw new PayErrorException(new PayException("IOException", e.getMessage()));
        }
    }

    public static JSONObject toJSONObject(String content) {
        return XML.toJSONObject(content, Charset.defaultCharset());
    }

    public static JSONObject toJSONObject(String content, Charset charset) {
        if (StringUtils.isEmpty(content)) {
            return null;
        }
        return XML.toJSONObject(content.getBytes(charset));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JSONObject toJSONObject(byte[] content) {
        if (null == content) {
            return null;
        }
        try (ByteArrayInputStream in = new ByteArrayInputStream(content);){
            JSONObject jSONObject = (JSONObject)XML.inputStream2Map(in, null);
            return jSONObject;
        }
        catch (IOException e) {
            throw new PayErrorException(new PayException("IOException", e.getMessage()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T toBean(String content, Class<T> clazz) {
        if (null == content) return null;
        if ("".equals(content)) {
            return null;
        }
        try (ByteArrayInputStream in = new ByteArrayInputStream(content.getBytes("UTF-8"));){
            T t = XML.inputStream2Bean(in, clazz);
            return t;
        }
        catch (IOException e) {
            throw new PayErrorException(new PayException("IOException", e.getMessage()));
        }
    }

    public static JSON getChildren(NodeList children) {
        JSONObject json = null;
        for (int idx = 0; idx < children.getLength(); ++idx) {
            Node node = children.item(idx);
            NodeList nodeList = node.getChildNodes();
            if (node.getNodeType() == 1 && nodeList.getLength() <= 1) {
                if (null == json) {
                    json = new JSONObject();
                }
                ((JSONObject)json).put(node.getNodeName(), (Object)node.getTextContent());
                continue;
            }
            if (node.getNodeType() != 1 || nodeList.getLength() <= 1) continue;
            if (null == json) {
                json = new JSONObject();
            }
            if (json instanceof JSONObject) {
                JSONObject j = json;
                if (j.containsKey((Object)node.getNodeName())) {
                    JSONArray array = new JSONArray();
                    array.add((Object)json);
                    json = array;
                } else {
                    j.put(node.getNodeName(), (Object)XML.getChildren(nodeList));
                }
            }
            if (!(json instanceof JSONArray)) continue;
            JSONObject c = new JSONObject();
            c.put(node.getNodeName(), (Object)XML.getChildren(nodeList));
            ((JSONArray)json).add((Object)c);
        }
        return json;
    }

    public static DocumentBuilder newDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        documentBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        documentBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        documentBuilderFactory.setXIncludeAware(false);
        documentBuilderFactory.setExpandEntityReferences(false);
        return documentBuilderFactory.newDocumentBuilder();
    }

    public static Document newDocument() throws ParserConfigurationException {
        return XML.newDocumentBuilder().newDocument();
    }

    public static <T> T inputStream2Bean(InputStream in, Class<T> clazz) throws IOException {
        try {
            DocumentBuilder documentBuilder = XML.newDocumentBuilder();
            Document doc = documentBuilder.parse(in);
            doc.getDocumentElement().normalize();
            NodeList children = doc.getDocumentElement().getChildNodes();
            JSON json = XML.getChildren(children);
            Object object = json.toJavaObject(clazz);
            return (T)object;
        }
        catch (Exception e) {
            throw new PayErrorException(new PayException("XML failure", "XML\u89e3\u6790\u5931\u8d25\n" + e.getMessage()));
        }
        finally {
            in.close();
        }
    }

    public static Map inputStream2Map(InputStream in, Map m) throws IOException {
        if (null == m) {
            m = new JSONObject();
        }
        try {
            DocumentBuilder documentBuilder = XML.newDocumentBuilder();
            Document doc = documentBuilder.parse(in);
            doc.getDocumentElement().normalize();
            NodeList children = doc.getDocumentElement().getChildNodes();
            for (int idx = 0; idx < children.getLength(); ++idx) {
                Node node = children.item(idx);
                NodeList nodeList = node.getChildNodes();
                if (node.getNodeType() == 1 && nodeList.getLength() <= 1) {
                    m.put(node.getNodeName(), node.getTextContent());
                    continue;
                }
                if (node.getNodeType() != 1 || nodeList.getLength() <= 1) continue;
                m.put(node.getNodeName(), XML.getChildren(nodeList));
            }
        }
        catch (Exception e) {
            throw new PayErrorException(new PayException("XML failure", "XML\u89e3\u6790\u5931\u8d25\n" + e.getMessage()));
        }
        finally {
            in.close();
        }
        return m;
    }

    public static String getMap2Xml(Map<String, Object> data) {
        return XML.getMap2Xml(data, "xml", "UTF-8");
    }

    public static String getMap2Xml(Map<String, Object> data, String rootElementName, String encoding) {
        Document document = null;
        try {
            document = XML.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new PayErrorException(new PayException("ParserConfigurationException", e.getLocalizedMessage()));
        }
        Element root = document.createElement(rootElementName);
        document.appendChild(root);
        XML.map2Xml(data, document, root);
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            DOMSource source = new DOMSource(document);
            transformer.setOutputProperty("encoding", encoding);
            transformer.setOutputProperty("indent", "yes");
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            transformer.transform(source, result);
            String output = writer.getBuffer().toString();
            return output;
        }
        catch (TransformerException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static void map2Xml(Map<String, Object> data, Document document, Element element) {
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            Object value = entry.getValue();
            if (value == null) {
                value = "";
            }
            Element filed = document.createElement(entry.getKey());
            if (value instanceof Map) {
                XML.map2Xml((Map)value, document, filed);
            } else {
                value = value.toString().trim();
                filed.appendChild(document.createTextNode(value.toString()));
            }
            element.appendChild(filed);
        }
    }
}

