/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.fuiou.api;

import com.alibaba.fastjson.JSONObject;
import com.egzosn.pay.common.api.BasePayService;
import com.egzosn.pay.common.api.PayConfigStorage;
import com.egzosn.pay.common.bean.AssistOrder;
import com.egzosn.pay.common.bean.BillType;
import com.egzosn.pay.common.bean.MethodType;
import com.egzosn.pay.common.bean.NoticeParams;
import com.egzosn.pay.common.bean.NoticeRequest;
import com.egzosn.pay.common.bean.Order;
import com.egzosn.pay.common.bean.OrderParaStructure;
import com.egzosn.pay.common.bean.PayMessage;
import com.egzosn.pay.common.bean.PayOrder;
import com.egzosn.pay.common.bean.PayOutMessage;
import com.egzosn.pay.common.bean.RefundOrder;
import com.egzosn.pay.common.bean.RefundResult;
import com.egzosn.pay.common.bean.TransactionType;
import com.egzosn.pay.common.exception.PayErrorException;
import com.egzosn.pay.common.http.HttpConfigStorage;
import com.egzosn.pay.common.http.UriVariables;
import com.egzosn.pay.common.util.DateUtils;
import com.egzosn.pay.common.util.Util;
import com.egzosn.pay.common.util.sign.SignTextUtils;
import com.egzosn.pay.common.util.sign.SignUtils;
import com.egzosn.pay.fuiou.api.FuiouPayConfigStorage;
import com.egzosn.pay.fuiou.bean.FuiouRefundResult;
import com.egzosn.pay.fuiou.bean.FuiouTransactionType;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class FuiouPayService
extends BasePayService<FuiouPayConfigStorage> {
    public static final String URL_FUIOU_BASE_DOMAIN = "https://pay.fuiou.com/";
    public static final String DEV_URL_FUIOU_BASE_DOMAIN = "http://www-1.fuiou.com:8888/wg1_run/";
    public static final String URL_FuiouSmpGate = "smpGate.do";
    public static final String URL_FuiouNewSmpGate = "newSmpGate.do";
    public static final String URL_FuiouSmpRefundGate = "newSmpRefundGate.do";
    public static final String URL_FuiouSmpQueryGate = "smpQueryGate.do";
    public static final String URL_FuiouSmpAQueryGate = "smpAQueryGate.do";
    public static final String URL_NewSmpRefundGate = "newSmpRefundGate.do";
    public static final String BACK_NOTIFY_URL = "back_notify_url";

    public String getReqUrl(TransactionType transactionType) {
        return ((FuiouPayConfigStorage)this.payConfigStorage).isTest() ? DEV_URL_FUIOU_BASE_DOMAIN : URL_FUIOU_BASE_DOMAIN;
    }

    public String getReqUrl() {
        return this.getReqUrl(null);
    }

    public FuiouPayService(FuiouPayConfigStorage payConfigStorage, HttpConfigStorage configStorage) {
        super((PayConfigStorage)payConfigStorage, configStorage);
    }

    public FuiouPayService(FuiouPayConfigStorage payConfigStorage) {
        super((PayConfigStorage)payConfigStorage);
    }

    @Deprecated
    public boolean verify(Map<String, Object> params) {
        return this.verify(new NoticeParams(params));
    }

    public boolean verify(NoticeParams noticeParams) {
        Map params = noticeParams.getBody();
        if (!"0000".equals(params.get("order_pay_code"))) {
            this.LOG.debug(String.format("\u5bcc\u53cb\u652f\u4ed8\u5f02\u5e38\uff1aorder_pay_code=%s,\u9519\u8bef\u539f\u56e0=%s,\u53c2\u6570\u96c6=%s", params.get("order_pay_code"), params.get("order_pay_error"), params));
            return false;
        }
        try {
            return this.signVerify(params, (String)params.remove("md5")) && this.verifySource((String)params.get("order_id"));
        }
        catch (PayErrorException e) {
            this.LOG.error("", (Throwable)e);
            return false;
        }
    }

    public boolean signVerify(Map<String, Object> params, String responseSign) {
        String sign = this.createSign(SignTextUtils.parameters2Md5Str(params, (String)"|"), ((FuiouPayConfigStorage)this.payConfigStorage).getInputCharset());
        return responseSign.equals(sign);
    }

    public boolean verifySource(String orderId) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>(3);
        params.put("mchnt_cd", ((FuiouPayConfigStorage)this.payConfigStorage).getPid());
        params.put("order_id", orderId);
        params.put("md5", this.createSign(SignTextUtils.parameters2Md5Str(params, (String)"|"), ((FuiouPayConfigStorage)this.payConfigStorage).getInputCharset()));
        JSONObject resultJson = (JSONObject)this.getHttpRequestTemplate().postForObject(this.getReqUrl() + URL_FuiouSmpAQueryGate + "?" + UriVariables.getMapToParameters(params), null, JSONObject.class, new Object[0]);
        if (null == resultJson) {
            return false;
        }
        return "0000".equals(resultJson.getJSONObject("plain").getString("order_pay_code"));
    }

    public Map<String, Object> orderInfo(PayOrder order) {
        if (null == order.getTransactionType()) {
            order.setTransactionType((TransactionType)FuiouTransactionType.B2C);
        }
        Map<String, Object> parameters = this.getOrderInfo(order);
        String sign = this.createSign(SignTextUtils.parameters2Md5Str(parameters, (String)"|"), ((FuiouPayConfigStorage)this.payConfigStorage).getInputCharset());
        parameters.put("md5", sign);
        return parameters;
    }

    private Map<String, Object> initNotifyUrl(Map<String, Object> parameters, AssistOrder order) {
        OrderParaStructure.loadParameters(parameters, (String)BACK_NOTIFY_URL, (String)((FuiouPayConfigStorage)this.payConfigStorage).getNotifyUrl());
        OrderParaStructure.loadParameters(parameters, (String)BACK_NOTIFY_URL, (String)order.getNotifyUrl());
        OrderParaStructure.loadParameters(parameters, (String)BACK_NOTIFY_URL, (Order)order);
        return parameters;
    }

    private Map<String, Object> getOrderInfo(PayOrder order) {
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>();
        parameters.put("mchnt_cd", ((FuiouPayConfigStorage)this.payConfigStorage).getPid());
        parameters.put("order_id", order.getOutTradeNo());
        parameters.put("order_amt", Util.conversionCentAmount((BigDecimal)order.getPrice()));
        parameters.put("order_pay_type", order.getTransactionType());
        parameters.put("page_notify_url", ((FuiouPayConfigStorage)this.payConfigStorage).getReturnUrl());
        this.initNotifyUrl(parameters, (AssistOrder)order);
        if (null != order.getExpirationTime()) {
            parameters.put("order_valid_time", DateUtils.minutesRemaining((Date)order.getExpirationTime()) + "m");
        } else {
            parameters.put("order_valid_time", "30m");
        }
        parameters.put("iss_ins_cd", order.getBankType());
        parameters.put("goods_name", order.getSubject());
        parameters.put("goods_display_url", "");
        parameters.put("rem", "");
        parameters.put("ver", "1.0.1");
        parameters.putAll(order.getAttrs());
        return this.preOrderHandler(parameters, order);
    }

    public String createSign(String content, String characterEncoding) {
        return SignUtils.valueOf((String)((FuiouPayConfigStorage)this.payConfigStorage).getSignType().toUpperCase()).createSign(content, "|" + ((FuiouPayConfigStorage)this.payConfigStorage).getKeyPrivate(), characterEncoding);
    }

    public NoticeParams getNoticeParams(NoticeRequest request) {
        Map parameterMap = request.getParameterMap();
        Map<String, Object> params = this.conversion(parameterMap, new LinkedHashMap<String, Object>(), "mchnt_cd");
        this.conversion(parameterMap, params, "order_id");
        this.conversion(parameterMap, params, "order_date");
        this.conversion(parameterMap, params, "order_amt");
        this.conversion(parameterMap, params, "order_st");
        this.conversion(parameterMap, params, "order_pay_code");
        this.conversion(parameterMap, params, "order_pay_error");
        this.conversion(parameterMap, params, "resv1");
        this.conversion(parameterMap, params, "fy_ssn");
        this.conversion(parameterMap, params, "md5");
        return new NoticeParams(params);
    }

    public Map<String, Object> conversion(Map<String, String[]> parameterMap, Map<String, Object> params, String key) {
        String[] values = parameterMap.get(key);
        String valueStr = "";
        int len = values.length;
        for (int i = 0; i < len; ++i) {
            valueStr = valueStr + (i == len - 1 ? values[i] : values[i] + ",");
        }
        params.put(key, valueStr);
        return params;
    }

    public PayOutMessage getPayOutMessage(String code, String message) {
        return PayOutMessage.TEXT().content(code.toLowerCase()).build();
    }

    public PayOutMessage successPayOutMessage(PayMessage payMessage) {
        return PayOutMessage.TEXT().content("success").build();
    }

    public String buildRequest(Map<String, Object> orderInfo, MethodType method) {
        return this.getFormString(orderInfo, method, this.getReqUrl() + URL_FuiouSmpGate);
    }

    public String getQrPay(PayOrder order) {
        throw new UnsupportedOperationException();
    }

    public Map<String, Object> microPay(PayOrder order) {
        throw new UnsupportedOperationException();
    }

    private String getFormString(Map<String, Object> param, MethodType method, String url) {
        StringBuffer formHtml = new StringBuffer();
        formHtml.append("<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
        formHtml.append("<title>\u63d0\u4ea4\u5230\u5bcc\u53cb\u4ea4\u6613\u7cfb\u7edf</title></head>");
        formHtml.append("<script type=\"text/javascript\">function submitForm()");
        formHtml.append("{document.getElementById(\"form\").submit();} </script>");
        formHtml.append("<body onload=\"javascript:submitForm();\">");
        formHtml.append("<form name=\"pay\" method=\"" + method.name().toLowerCase() + "\" ");
        formHtml.append("action=\"" + url + "\" id = \"form\">");
        for (Map.Entry<String, Object> entry : param.entrySet()) {
            Object o = entry.getValue();
            formHtml.append("<input type=\"hidden\" value = '" + o + "' name=\"" + entry.getKey() + "\"/>");
        }
        formHtml.append("</form></body></html>");
        return formHtml.toString();
    }

    public Map<String, Object> query(String tradeNo, String outTradeNo) {
        return this.query(new AssistOrder(tradeNo, outTradeNo));
    }

    public Map<String, Object> query(AssistOrder assistOrder) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("mchnt_cd", ((FuiouPayConfigStorage)this.payConfigStorage).getPid());
        params.put("order_id", assistOrder.getOutTradeNo());
        params.put("md5", this.createSign(SignTextUtils.parameters2Md5Str(params, (String)"|"), ((FuiouPayConfigStorage)this.payConfigStorage).getInputCharset()));
        return (Map)this.getHttpRequestTemplate().postForObject(this.getReqUrl() + URL_FuiouSmpAQueryGate + "?" + UriVariables.getMapToParameters(params), null, JSONObject.class, new Object[0]);
    }

    public Map<String, Object> close(String tradeNo, String outTradeNo) {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u8be5\u64cd\u4f5c");
    }

    public Map<String, Object> close(AssistOrder assistOrder) {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u8be5\u64cd\u4f5c");
    }

    public RefundResult refund(RefundOrder refundOrder) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("mchnt_cd", ((FuiouPayConfigStorage)this.payConfigStorage).getPid());
        params.put("origin_order_date", refundOrder.getOrderDate());
        params.put("origin_order_id", refundOrder.getTradeNo());
        params.put("refund_amt", Util.conversionCentAmount((BigDecimal)refundOrder.getRefundAmount()));
        params.put("rem", "");
        params.putAll(refundOrder.getAttrs());
        params.put("md5", this.createSign(SignTextUtils.parameters2Md5Str(params, (String)"|"), ((FuiouPayConfigStorage)this.payConfigStorage).getInputCharset()));
        JSONObject resultJson = (JSONObject)this.getHttpRequestTemplate().postForObject(this.getReqUrl() + "newSmpRefundGate.do", params, JSONObject.class, new Object[0]);
        return FuiouRefundResult.create((Map<String, Object>)resultJson);
    }

    public Map<String, Object> refundquery(RefundOrder refundOrder) {
        return Collections.emptyMap();
    }

    public Map<String, Object> downloadBill(Date billDate, BillType billType) {
        return Collections.emptyMap();
    }
}

