/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.union.api;

import com.alibaba.fastjson.JSONObject;
import com.egzosn.pay.common.api.BasePayService;
import com.egzosn.pay.common.api.PayConfigStorage;
import com.egzosn.pay.common.bean.AssistOrder;
import com.egzosn.pay.common.bean.BillType;
import com.egzosn.pay.common.bean.MethodType;
import com.egzosn.pay.common.bean.NoticeParams;
import com.egzosn.pay.common.bean.PayMessage;
import com.egzosn.pay.common.bean.PayOrder;
import com.egzosn.pay.common.bean.PayOutMessage;
import com.egzosn.pay.common.bean.RefundOrder;
import com.egzosn.pay.common.bean.TransactionType;
import com.egzosn.pay.common.bean.outbuilder.PayTextOutMessage;
import com.egzosn.pay.common.bean.result.PayError;
import com.egzosn.pay.common.bean.result.PayException;
import com.egzosn.pay.common.exception.PayErrorException;
import com.egzosn.pay.common.http.HttpConfigStorage;
import com.egzosn.pay.common.http.UriVariables;
import com.egzosn.pay.common.util.DateUtils;
import com.egzosn.pay.common.util.Util;
import com.egzosn.pay.common.util.sign.CertDescriptor;
import com.egzosn.pay.common.util.sign.SignTextUtils;
import com.egzosn.pay.common.util.sign.SignUtils;
import com.egzosn.pay.common.util.sign.encrypt.RSA;
import com.egzosn.pay.common.util.sign.encrypt.RSA2;
import com.egzosn.pay.common.util.str.StringUtils;
import com.egzosn.pay.union.api.UnionPayConfigStorage;
import com.egzosn.pay.union.bean.UnionPayBillType;
import com.egzosn.pay.union.bean.UnionPayMessage;
import com.egzosn.pay.union.bean.UnionRefundResult;
import com.egzosn.pay.union.bean.UnionTransactionType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;

public class UnionPayService
extends BasePayService<UnionPayConfigStorage> {
    private static final String TEST_BASE_DOMAIN = "test.95516.com";
    private static final String RELEASE_BASE_DOMAIN = "95516.com";
    private static final String FRONT_TRANS_URL = "https://gateway.%s/gateway/api/frontTransReq.do";
    private static final String BACK_TRANS_URL = "https://gateway.%s/gateway/api/backTransReq.do";
    private static final String SINGLE_QUERY_URL = "https://gateway.%s/gateway/api/queryTrans.do";
    private static final String BATCH_TRANS_URL = "https://gateway.%s/gateway/api/batchTrans.do";
    private static final String FILE_TRANS_URL = "https://filedownload.%s/";
    private static final String APP_TRANS_URL = "https://gateway.%s/gateway/api/appTransReq.do";
    private static final String CARD_TRANS_URL = "https://gateway.%s/gateway/api/cardTransReq.do";
    private volatile CertDescriptor certDescriptor;

    public UnionPayService(UnionPayConfigStorage payConfigStorage) {
        this(payConfigStorage, null);
    }

    public UnionPayService(UnionPayConfigStorage payConfigStorage, HttpConfigStorage configStorage) {
        super((PayConfigStorage)payConfigStorage, configStorage);
    }

    public UnionPayService setPayConfigStorage(UnionPayConfigStorage payConfigStorage) {
        this.payConfigStorage = payConfigStorage;
        if (null != this.certDescriptor) {
            return this;
        }
        try {
            this.certDescriptor = new CertDescriptor();
            this.certDescriptor.initPrivateSignCert(payConfigStorage.getKeyPrivateCertInputStream(), payConfigStorage.getKeyPrivateCertPwd(), "PKCS12");
            this.certDescriptor.initPublicCert(payConfigStorage.getAcpMiddleCertInputStream());
            this.certDescriptor.initRootCert(payConfigStorage.getAcpRootCertInputStream());
        }
        catch (IOException e) {
            this.LOG.error("", (Throwable)e);
        }
        return this;
    }

    public String getReqUrl(TransactionType transactionType) {
        return ((UnionPayConfigStorage)this.payConfigStorage).isTest() ? TEST_BASE_DOMAIN : RELEASE_BASE_DOMAIN;
    }

    public String getReqUrl() {
        return this.getReqUrl(null);
    }

    public String getFrontTransUrl() {
        return String.format(FRONT_TRANS_URL, this.getReqUrl());
    }

    public String getBackTransUrl() {
        return String.format(BACK_TRANS_URL, this.getReqUrl());
    }

    public String getAppTransUrl() {
        return String.format(APP_TRANS_URL, this.getReqUrl());
    }

    public String getSingleQueryUrl() {
        return String.format(SINGLE_QUERY_URL, this.getReqUrl());
    }

    public String getFileTransUrl() {
        return String.format(FILE_TRANS_URL, this.getReqUrl());
    }

    private Map<String, Object> getCommonParam() {
        TreeMap<String, Object> params = new TreeMap<String, Object>();
        UnionPayConfigStorage configStorage = (UnionPayConfigStorage)this.payConfigStorage;
        params.put("version", configStorage.getVersion());
        params.put("encoding", ((UnionPayConfigStorage)this.payConfigStorage).getInputCharset().toUpperCase());
        params.put("merId", ((UnionPayConfigStorage)this.payConfigStorage).getPid());
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        params.put("txnTime", df.format(System.currentTimeMillis()));
        params.put("backUrl", ((UnionPayConfigStorage)this.payConfigStorage).getNotifyUrl());
        params.put("currencyCode", "156");
        params.put("accessType", configStorage.getAccessType());
        return params;
    }

    @Deprecated
    public boolean verify(Map<String, Object> result) {
        return this.verify(new NoticeParams(result));
    }

    public boolean verify(NoticeParams noticeParams) {
        Map result = noticeParams.getBody();
        if (null == result || result.get("signature") == null) {
            this.LOG.debug("\u94f6\u8054\u652f\u4ed8\u9a8c\u7b7e\u5f02\u5e38\uff1aparams\uff1a" + result);
            return false;
        }
        return this.signVerify(result, (String)result.get("signature"));
    }

    public boolean signVerify(Map<String, Object> params, String sign) {
        SignUtils signUtils = SignUtils.valueOf((String)((UnionPayConfigStorage)this.payConfigStorage).getSignType());
        String data = SignTextUtils.parameterText(params, (String)"&", (String[])new String[]{"signature"});
        switch (signUtils) {
            case RSA: {
                data = SignUtils.SHA1.createSign(data, "", ((UnionPayConfigStorage)this.payConfigStorage).getInputCharset());
                return RSA.verify((String)data, (String)sign, (PublicKey)this.verifyCertificate(UnionPayService.genCertificateByStr((String)params.get("signPubKeyCert"))).getPublicKey(), (String)((UnionPayConfigStorage)this.payConfigStorage).getInputCharset());
            }
            case RSA2: {
                data = SignUtils.SHA256.createSign(data, "", ((UnionPayConfigStorage)this.payConfigStorage).getInputCharset());
                return RSA2.verify((String)data, (String)sign, (PublicKey)this.verifyCertificate(UnionPayService.genCertificateByStr((String)params.get("signPubKeyCert"))).getPublicKey(), (String)((UnionPayConfigStorage)this.payConfigStorage).getInputCharset());
            }
            case SHA1: 
            case SHA256: 
            case SM3: {
                String before = signUtils.createSign(((UnionPayConfigStorage)this.payConfigStorage).getKeyPublic(), "", ((UnionPayConfigStorage)this.payConfigStorage).getInputCharset());
                return signUtils.verify(data, sign, "&" + before, ((UnionPayConfigStorage)this.payConfigStorage).getInputCharset());
            }
        }
        return false;
    }

    private String getPayTimeout(Date expirationTime) {
        if (null != expirationTime) {
            return DateUtils.formatDate((Date)expirationTime, (String)"yyyyMMddHHmmss");
        }
        return DateUtils.formatDate((Date)new Timestamp(System.currentTimeMillis() + 1800000L), (String)"yyyyMMddHHmmss");
    }

    public Map<String, Object> orderInfo(PayOrder order) {
        Map params = this.getCommonParam();
        UnionTransactionType type = (UnionTransactionType)order.getTransactionType();
        type.convertMap(params);
        params.put((String)"orderId", (Object)order.getOutTradeNo());
        if (StringUtils.isNotEmpty((CharSequence)order.getAddition())) {
            params.put((String)"reqReserved", (Object)order.getAddition());
        }
        switch (type) {
            case WAP: 
            case WEB: 
            case B2B: {
                params.put((String)"txnAmt", Util.conversionCentAmount((BigDecimal)order.getPrice()));
                params.put((String)"orderDesc", (Object)order.getSubject());
                params.put((String)"payTimeout", (Object)this.getPayTimeout(order.getExpirationTime()));
                params.put("frontUrl", ((UnionPayConfigStorage)this.payConfigStorage).getReturnUrl());
                break;
            }
            case CONSUME: {
                params.put((String)"txnAmt", Util.conversionCentAmount((BigDecimal)order.getPrice()));
                params.put((String)"qrNo", (Object)order.getAuthCode());
                break;
            }
            case APPLY_QR_CODE: {
                if (null != order.getPrice()) {
                    params.put((String)"txnAmt", Util.conversionCentAmount((BigDecimal)order.getPrice()));
                }
                params.put((String)"payTimeout", (Object)this.getPayTimeout(order.getExpirationTime()));
                break;
            }
            default: {
                params.put((String)"txnAmt", Util.conversionCentAmount((BigDecimal)order.getPrice()));
                params.put((String)"payTimeout", (Object)this.getPayTimeout(order.getExpirationTime()));
                params.put((String)"orderDesc", (Object)order.getSubject());
            }
        }
        params.putAll(order.getAttrs());
        params = this.preOrderHandler(params, order);
        return this.setSign(params);
    }

    private Map<String, Object> setSign(Map<String, Object> parameters) {
        SignUtils signUtils = SignUtils.valueOf((String)((UnionPayConfigStorage)this.payConfigStorage).getSignType());
        switch (signUtils) {
            case RSA: {
                parameters.put("signMethod", "01");
                parameters.put("certId", this.certDescriptor.getSignCertId());
                String signStr = SignUtils.SHA1.createSign(SignTextUtils.parameterText(parameters, (String)"&", (String[])new String[]{"signature"}), "", ((UnionPayConfigStorage)this.payConfigStorage).getInputCharset());
                parameters.put("signature", RSA.sign((String)signStr, (PrivateKey)this.certDescriptor.getSignCertPrivateKey(((UnionPayConfigStorage)this.payConfigStorage).getKeyPrivateCertPwd()), (String)((UnionPayConfigStorage)this.payConfigStorage).getInputCharset()));
                break;
            }
            case RSA2: {
                parameters.put("signMethod", "01");
                parameters.put("certId", this.certDescriptor.getSignCertId());
                String signStr = SignUtils.SHA256.createSign(SignTextUtils.parameterText(parameters, (String)"&", (String[])new String[]{"signature"}), "", ((UnionPayConfigStorage)this.payConfigStorage).getInputCharset());
                parameters.put("signature", RSA2.sign((String)signStr, (PrivateKey)this.certDescriptor.getSignCertPrivateKey(((UnionPayConfigStorage)this.payConfigStorage).getKeyPrivateCertPwd()), (String)((UnionPayConfigStorage)this.payConfigStorage).getInputCharset()));
                break;
            }
            case SHA1: 
            case SHA256: 
            case SM3: {
                String key = ((UnionPayConfigStorage)this.payConfigStorage).getKeyPrivate();
                String signStr = SignTextUtils.parameterText(parameters, (String)"&", (String[])new String[]{"signature"});
                key = signUtils.createSign(key, "", ((UnionPayConfigStorage)this.payConfigStorage).getInputCharset()) + "&";
                parameters.put("signature", signUtils.createSign(signStr, key, ((UnionPayConfigStorage)this.payConfigStorage).getInputCharset()));
                break;
            }
            default: {
                throw new PayErrorException((PayError)new PayException("sign fail", "\u672a\u627e\u5230\u7684\u7b7e\u540d\u7c7b\u578b"));
            }
        }
        return parameters;
    }

    private X509Certificate verifyCertificate(X509Certificate cert) {
        try {
            cert.checkValidity();
            X509Certificate middleCert = this.certDescriptor.getPublicCert();
            X509Certificate rootCert = this.certDescriptor.getRootCert();
            X509CertSelector selector = new X509CertSelector();
            selector.setCertificate(cert);
            HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
            trustAnchors.add(new TrustAnchor(rootCert, null));
            PKIXBuilderParameters pkixParams = new PKIXBuilderParameters(trustAnchors, (CertSelector)selector);
            HashSet<X509Certificate> intermediateCerts = new HashSet<X509Certificate>();
            intermediateCerts.add(rootCert);
            intermediateCerts.add(middleCert);
            intermediateCerts.add(cert);
            pkixParams.setRevocationEnabled(false);
            CertStore intermediateCertStore = CertStore.getInstance("Collection", new CollectionCertStoreParameters(intermediateCerts));
            pkixParams.addCertStore(intermediateCertStore);
            CertPathBuilder builder = CertPathBuilder.getInstance("PKIX");
            builder.build(pkixParams);
            return cert;
        }
        catch (CertPathBuilderException e) {
            this.LOG.error("verify certificate chain fail.", (Throwable)e);
        }
        catch (CertificateExpiredException e) {
            this.LOG.error("", (Throwable)e);
        }
        catch (GeneralSecurityException e) {
            this.LOG.error("", (Throwable)e);
        }
        return null;
    }

    public JSONObject postOrder(PayOrder order, String url) {
        Map<String, Object> params = this.orderInfo(order);
        String responseStr = (String)this.getHttpRequestTemplate().postForObject(url, params, String.class, new Object[0]);
        JSONObject response = UriVariables.getParametersToMap((String)responseStr);
        if (response.isEmpty()) {
            throw new PayErrorException((PayError)new PayException("failure", "\u54cd\u5e94\u5185\u5bb9\u6709\u8bef!", responseStr));
        }
        return response;
    }

    public String toPay(PayOrder order) {
        if (null == order.getTransactionType()) {
            order.setTransactionType((TransactionType)UnionTransactionType.WEB);
        } else if (UnionTransactionType.WEB != order.getTransactionType() && UnionTransactionType.WAP != order.getTransactionType() && UnionTransactionType.B2B != order.getTransactionType()) {
            throw new PayErrorException((PayError)new PayException("-1", "\u9519\u8bef\u7684\u4ea4\u6613\u7c7b\u578b:" + order.getTransactionType()));
        }
        return super.toPay(order);
    }

    public String getQrPay(PayOrder order) {
        order.setTransactionType((TransactionType)UnionTransactionType.APPLY_QR_CODE);
        JSONObject response = this.postOrder(order, this.getBackTransUrl());
        if (this.verify((Map<String, Object>)response)) {
            if ("00".equals(response.get((Object)"respCode"))) {
                return (String)response.get((Object)"qrCode");
            }
            throw new PayErrorException((PayError)new PayException((String)response.get((Object)"respCode"), (String)response.get((Object)"respMsg"), response.toJSONString()));
        }
        throw new PayErrorException((PayError)new PayException("failure", "\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25", response.toJSONString()));
    }

    public Map<String, Object> microPay(PayOrder order) {
        order.setTransactionType((TransactionType)UnionTransactionType.CONSUME);
        JSONObject response = this.postOrder(order, this.getBackTransUrl());
        return response;
    }

    public static X509Certificate genCertificateByStr(String x509CertString) {
        X509Certificate x509Cert = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream tIn = new ByteArrayInputStream(x509CertString.getBytes("ISO-8859-1"));
            x509Cert = (X509Certificate)cf.generateCertificate(tIn);
        }
        catch (Exception e) {
            throw new PayErrorException((PayError)new PayException("\u8bc1\u4e66\u52a0\u8f7d\u5931\u8d25", "gen certificate error:" + e.getLocalizedMessage()));
        }
        return x509Cert;
    }

    public PayOutMessage getPayOutMessage(String code, String message) {
        return PayTextOutMessage.TEXT().content(code.toLowerCase()).build();
    }

    public PayOutMessage successPayOutMessage(PayMessage payMessage) {
        return this.getPayOutMessage("ok", null);
    }

    public String buildRequest(Map<String, Object> orderInfo, MethodType method) {
        StringBuffer sf = new StringBuffer();
        sf.append("<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + ((UnionPayConfigStorage)this.payConfigStorage).getInputCharset() + "\"/></head><body>");
        sf.append("<form id = \"pay_form\" action=\"" + this.getFrontTransUrl() + "\" method=\"post\">");
        if (null != orderInfo && 0 != orderInfo.size()) {
            for (Map.Entry<String, Object> entry : orderInfo.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                sf.append("<input type=\"hidden\" name=\"" + key + "\" id=\"" + key + "\" value=\"" + value + "\"/>");
            }
        }
        sf.append("</form>");
        sf.append("</body>");
        sf.append("<script type=\"text/javascript\">");
        sf.append("document.all.pay_form.submit();");
        sf.append("</script>");
        sf.append("</html>");
        return sf.toString();
    }

    public Map<String, Object> app(PayOrder order) {
        JSONObject response;
        if (null == order.getTransactionType()) {
            order.setTransactionType((TransactionType)UnionTransactionType.APP);
        }
        if (this.verify((Map<String, Object>)(response = this.postOrder(order, this.getAppTransUrl())))) {
            if ("00".equals(response.get((Object)"respCode"))) {
                return response;
            }
            throw new PayErrorException((PayError)new PayException((String)response.get((Object)"respCode"), (String)response.get((Object)"respMsg"), response.toJSONString()));
        }
        throw new PayErrorException((PayError)new PayException("failure", "\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25", response.toJSONString()));
    }

    public Map<String, Object> query(String tradeNo, String outTradeNo) {
        return this.query(new AssistOrder(tradeNo, outTradeNo));
    }

    public Map<String, Object> query(AssistOrder assistOrder) {
        Map<String, Object> params = this.getCommonParam();
        UnionTransactionType.QUERY.convertMap(params);
        params.put("orderId", assistOrder.getOutTradeNo());
        this.setSign(params);
        String responseStr = (String)this.getHttpRequestTemplate().postForObject(this.getSingleQueryUrl(), params, String.class, new Object[0]);
        JSONObject response = UriVariables.getParametersToMap((String)responseStr);
        if (this.verify(new NoticeParams((Map)response))) {
            String origRespCode;
            if ("00".equals(response.getString("respCode")) && "00".equals(origRespCode = response.getString("origRespCode"))) {
                return response;
            }
            throw new PayErrorException((PayError)new PayException(response.getString("respCode"), response.getString("respMsg"), response.toJSONString()));
        }
        throw new PayErrorException((PayError)new PayException("failure", "\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25", response.toJSONString()));
    }

    public UnionRefundResult unionRefundOrConsumeUndo(String origQryId, String orderId, BigDecimal refundAmount, UnionTransactionType type) {
        return this.unionRefundOrConsumeUndo(new RefundOrder(orderId, origQryId, refundAmount), type);
    }

    public UnionRefundResult unionRefundOrConsumeUndo(RefundOrder refundOrder, UnionTransactionType type) {
        Map<String, Object> params = this.getCommonParam();
        type.convertMap(params);
        params.put("orderId", refundOrder.getRefundNo());
        params.put("txnAmt", Util.conversionCentAmount((BigDecimal)refundOrder.getRefundAmount()));
        params.put("origQryId", refundOrder.getTradeNo());
        params.putAll(refundOrder.getAttrs());
        this.setSign(params);
        String responseStr = (String)this.getHttpRequestTemplate().postForObject(this.getBackTransUrl(), params, String.class, new Object[0]);
        JSONObject response = UriVariables.getParametersToMap((String)responseStr);
        if (this.verify((Map<String, Object>)response)) {
            UnionRefundResult refundResult = UnionRefundResult.create((Map<String, Object>)response);
            if ("00".equals(refundResult.getRespCode())) {
                return refundResult;
            }
            throw new PayErrorException((PayError)new PayException(response.getString("respCode"), response.getString("respMsg"), response.toJSONString()));
        }
        throw new PayErrorException((PayError)new PayException("failure", "\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25", response.toJSONString()));
    }

    public Map<String, Object> close(String tradeNo, String outTradeNo) {
        return Collections.emptyMap();
    }

    public Map<String, Object> close(AssistOrder assistOrder) {
        return Collections.emptyMap();
    }

    public UnionRefundResult refund(RefundOrder refundOrder) {
        return this.unionRefundOrConsumeUndo(refundOrder, UnionTransactionType.REFUND);
    }

    public Map<String, Object> refundquery(RefundOrder refundOrder) {
        return Collections.emptyMap();
    }

    public Map<String, Object> downloadBill(Date billDate, String fileType) {
        return this.downloadBill(billDate, new UnionPayBillType(fileType));
    }

    public Map<String, Object> downloadBill(Date billDate, BillType billType) {
        Map<String, Object> params = this.getCommonParam();
        UnionTransactionType.FILE_TRANSFER.convertMap(params);
        params.put("settleDate", DateUtils.formatDate((Date)billDate, (String)"MMdd"));
        params.put("fileType", billType.getFileType());
        params.remove("backUrl");
        params.remove("currencyCode");
        this.setSign(params);
        String responseStr = (String)this.getHttpRequestTemplate().postForObject(this.getFileTransUrl(), params, String.class, new Object[0]);
        JSONObject response = UriVariables.getParametersToMap((String)responseStr);
        if (this.verify((Map<String, Object>)response)) {
            if ("00".equals(response.get((Object)"respCode"))) {
                return response;
            }
            throw new PayErrorException((PayError)new PayException(response.get((Object)"respCode").toString(), response.get((Object)"respMsg").toString(), response.toString()));
        }
        throw new PayErrorException((PayError)new PayException("failure", "\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25", response.toString()));
    }

    public PayMessage createMessage(Map<String, Object> message) {
        return UnionPayMessage.create(message);
    }
}

