/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.wx.youdian.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.egzosn.pay.common.api.BasePayService;
import com.egzosn.pay.common.api.PayConfigStorage;
import com.egzosn.pay.common.bean.AssistOrder;
import com.egzosn.pay.common.bean.BaseRefundResult;
import com.egzosn.pay.common.bean.BillType;
import com.egzosn.pay.common.bean.CurType;
import com.egzosn.pay.common.bean.MethodType;
import com.egzosn.pay.common.bean.NoticeParams;
import com.egzosn.pay.common.bean.NoticeRequest;
import com.egzosn.pay.common.bean.PayMessage;
import com.egzosn.pay.common.bean.PayOrder;
import com.egzosn.pay.common.bean.PayOutMessage;
import com.egzosn.pay.common.bean.RefundOrder;
import com.egzosn.pay.common.bean.RefundResult;
import com.egzosn.pay.common.bean.TransactionType;
import com.egzosn.pay.common.bean.result.PayError;
import com.egzosn.pay.common.exception.PayErrorException;
import com.egzosn.pay.common.http.HttpConfigStorage;
import com.egzosn.pay.common.util.Util;
import com.egzosn.pay.common.util.sign.SignTextUtils;
import com.egzosn.pay.common.util.sign.SignUtils;
import com.egzosn.pay.common.util.str.StringUtils;
import com.egzosn.pay.wx.youdian.api.WxYouDianPayConfigStorage;
import com.egzosn.pay.wx.youdian.bean.WxYoudianPayMessage;
import com.egzosn.pay.wx.youdian.bean.YdPayError;
import com.egzosn.pay.wx.youdian.bean.YoudianTransactionType;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;

public class WxYouDianPayService
extends BasePayService<WxYouDianPayConfigStorage> {
    private static final String URL = "http://life.51youdian.com/Api/CheckoutCounter/";

    public String getAccessToken() {
        return this.getAccessToken(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAccessToken(boolean forceRefresh) throws PayErrorException {
        block7: {
            Lock lock = ((WxYouDianPayConfigStorage)this.payConfigStorage).getAccessTokenLock();
            try {
                lock.lock();
                if (forceRefresh) {
                    ((WxYouDianPayConfigStorage)this.payConfigStorage).expireAccessToken();
                }
                if (!((WxYouDianPayConfigStorage)this.payConfigStorage).isAccessTokenExpired()) break block7;
                if (null == ((WxYouDianPayConfigStorage)this.payConfigStorage).getAccessToken()) {
                    this.login();
                    String string = ((WxYouDianPayConfigStorage)this.payConfigStorage).getAccessToken();
                    return string;
                }
                String apbNonce = SignTextUtils.randomStr();
                StringBuilder param = new StringBuilder().append("access_token=").append(((WxYouDianPayConfigStorage)this.payConfigStorage).getAccessToken());
                String sign = this.createSign(param.toString() + apbNonce, ((WxYouDianPayConfigStorage)this.payConfigStorage).getInputCharset());
                param.append("&apb_nonce=").append(apbNonce).append("&sign=").append(sign);
                JSONObject json = this.execute(this.getReqUrl(YoudianTransactionType.RESET_LOGIN) + "?" + param.toString(), MethodType.GET, null);
                int errorcode = json.getIntValue("errorcode");
                if (0 == errorcode) {
                    ((WxYouDianPayConfigStorage)this.payConfigStorage).updateAccessToken(((WxYouDianPayConfigStorage)this.payConfigStorage).getAccessToken(), 7200);
                    break block7;
                }
                throw new PayErrorException((PayError)new YdPayError(errorcode, json.getString("msg"), json.toJSONString()));
            }
            finally {
                lock.unlock();
            }
        }
        return ((WxYouDianPayConfigStorage)this.payConfigStorage).getAccessToken();
    }

    public JSONObject login() throws PayErrorException {
        TreeMap<String, String> data = new TreeMap<String, String>();
        data.put("username", ((WxYouDianPayConfigStorage)this.payConfigStorage).getSeller());
        data.put("password", ((WxYouDianPayConfigStorage)this.payConfigStorage).getKeyPrivate());
        String apbNonce = SignTextUtils.randomStr();
        String sign = this.createSign(SignTextUtils.parameterText(data, (String)"") + apbNonce, ((WxYouDianPayConfigStorage)this.payConfigStorage).getInputCharset());
        String queryParam = SignTextUtils.parameterText(data) + "&apb_nonce=" + apbNonce + "&sign=" + sign;
        JSONObject json = this.execute(this.getReqUrl(YoudianTransactionType.LOGIN) + "?" + queryParam, MethodType.GET, null);
        ((WxYouDianPayConfigStorage)this.payConfigStorage).updateAccessToken(json.getString("access_token"), json.getLongValue("viptime"));
        return json;
    }

    @Deprecated
    public boolean verify(Map<String, Object> params) {
        return this.verify(new NoticeParams(params));
    }

    public boolean verify(NoticeParams noticeParams) {
        Map params = noticeParams.getBody();
        if (!"SUCCESS".equals(params.get("return_code"))) {
            this.LOG.debug(String.format("\u53cb\u5e97\u5fae\u4fe1\u652f\u4ed8\u5f02\u5e38\uff1areturn_code=%s,\u53c2\u6570\u96c6=%s", params.get("return_code"), params));
            return false;
        }
        if (params.get("sign") == null) {
            this.LOG.debug("\u53cb\u5e97\u5fae\u4fe1\u652f\u4ed8\u5f02\u5e38\uff1a\u7b7e\u540d\u4e3a\u7a7a\uff01out_trade_no=" + params.get("out_trade_no"));
        }
        try {
            return this.signVerify(params, (String)params.get("sign")) && this.verifySource((String)params.get("out_trade_no"));
        }
        catch (PayErrorException e) {
            this.LOG.error(e.getMessage());
            return false;
        }
    }

    public boolean signVerify(Map<String, Object> params, String sign) {
        return SignUtils.valueOf((String)((WxYouDianPayConfigStorage)this.payConfigStorage).getSignType()).verify(params, sign, "&key=" + ((WxYouDianPayConfigStorage)this.payConfigStorage).getKeyPublic(), ((WxYouDianPayConfigStorage)this.payConfigStorage).getInputCharset());
    }

    public boolean verifySource(String id) {
        try {
            JSONObject jsonObject = (JSONObject)this.query(id, null);
            return 0 == jsonObject.getIntValue("errorcode");
        }
        catch (PayErrorException e) {
            if (Integer.parseInt(e.getPayError().getErrorCode()) >= 400) {
                throw e;
            }
            return false;
        }
    }

    public JSONObject execute(String uri, MethodType method, Object request) throws PayErrorException {
        int retryTimes = 0;
        while (true) {
            try {
                JSONObject result = (JSONObject)this.requestTemplate.doExecute(uri, request, JSONObject.class, method);
                if (0 != result.getIntValue("errorcode")) {
                    throw new PayErrorException((PayError)new YdPayError(result.getIntValue("errorcode"), result.getString("msg"), result.toJSONString()));
                }
                return result;
            }
            catch (PayErrorException e) {
                PayError error = e.getPayError();
                if ("401".equals(error.getErrorCode()) || "500".equals(error.getErrorCode())) {
                    try {
                        int sleepMillis = this.retrySleepMillis * (1 << retryTimes);
                        this.LOG.debug(String.format("\u53cb\u5e97\u5fae\u4fe1\u7cfb\u7edf\u7e41\u5fd9\uff0c(%s)ms \u540e\u91cd\u8bd5(\u7b2c%s\u6b21)", sleepMillis, retryTimes + 1));
                        Thread.sleep(sleepMillis);
                    }
                    catch (InterruptedException e1) {
                        throw new PayErrorException((PayError)new YdPayError(-1, "\u53cb\u5e97\u652f\u4ed8\u670d\u52a1\u7aef\u91cd\u8bd5\u5931\u8d25", e1.getMessage()));
                    }
                } else {
                    throw e;
                }
                ((WxYouDianPayConfigStorage)this.payConfigStorage).expireAccessToken();
                this.login();
                if (++retryTimes < this.maxRetryTimes) continue;
                throw new PayErrorException((PayError)new YdPayError(-1, "\u53cb\u5e97\u5fae\u4fe1\u670d\u52a1\u7aef\u5f02\u5e38\uff0c\u8d85\u51fa\u91cd\u8bd5\u6b21\u6570"));
            }
            break;
        }
    }

    public JSONObject orderInfo(PayOrder order) {
        Map data = new TreeMap<String, String>();
        data.put("access_token", this.getAccessToken());
        data.put("paymoney", Util.conversionAmount((BigDecimal)order.getPrice()).toString());
        data.putAll(order.getAttrs());
        data = this.preOrderHandler(data, order);
        String apbNonce = SignTextUtils.randomStr();
        String sign = this.createSign(SignTextUtils.parameterText(data, (String)"") + apbNonce, ((WxYouDianPayConfigStorage)this.payConfigStorage).getInputCharset());
        data.put("PayMoney", data.remove("paymoney"));
        String params = SignTextUtils.parameterText(data) + "&apb_nonce=" + apbNonce + "&sign=" + sign;
        JSONObject json = this.execute(this.getReqUrl(order.getTransactionType()) + "?" + params, MethodType.GET, null);
        order.setTradeNo(json.getString("order_sn"));
        return json;
    }

    public String createSign(String content, String characterEncoding) {
        return SignUtils.valueOf((String)((WxYouDianPayConfigStorage)this.payConfigStorage).getSignType().toUpperCase()).createSign(content, "&source=http://life.51youdian.com", characterEncoding);
    }

    public NoticeParams getNoticeParams(NoticeRequest request) {
        Map parameterMap = request.getParameterMap();
        TreeMap<String, String> params = new TreeMap<String, String>();
        for (String name : parameterMap.keySet()) {
            String[] values = (String[])parameterMap.get(name);
            String valueStr = "";
            for (int i = 0; i < values.length; ++i) {
                valueStr = i == values.length - 1 ? valueStr + values[i] : valueStr + values[i] + ",";
            }
            params.put(name, valueStr.trim());
        }
        return new NoticeParams(params);
    }

    public PayOutMessage getPayOutMessage(String code, String message) {
        TreeMap<String, String> builder = new TreeMap<String, String>();
        builder.put("return_code", code.toUpperCase());
        builder.put("return_msg", message);
        builder.put("nonce_str", SignTextUtils.randomStr());
        String sgin = SignUtils.valueOf((String)((WxYouDianPayConfigStorage)this.payConfigStorage).getSignType()).sign(builder, "&key=" + ((WxYouDianPayConfigStorage)this.payConfigStorage).getKeyPrivate(), ((WxYouDianPayConfigStorage)this.payConfigStorage).getInputCharset());
        return PayOutMessage.TEXT().content("{\"return_code\":\"" + builder.get("return_code") + "\",\"return_msg\":\"" + builder.get("return_msg") + "\",\"nonce_str\":\"" + builder.get("nonce_str") + "\",\"sign\":\"" + sgin + "\"}").build();
    }

    public PayOutMessage successPayOutMessage(PayMessage payMessage) {
        return PayOutMessage.TEXT().content(JSON.toJSONString((Object)payMessage.getPayMessage())).build();
    }

    public String buildRequest(Map<String, Object> orderInfo, MethodType method) {
        throw new UnsupportedOperationException();
    }

    public String getQrPay(PayOrder order) {
        order.setTransactionType((TransactionType)YoudianTransactionType.NATIVE);
        JSONObject orderInfo = this.orderInfo(order);
        return (String)orderInfo.get((Object)"code_url");
    }

    public Map<String, Object> microPay(PayOrder order) {
        order.setTransactionType((TransactionType)YoudianTransactionType.MICROPAY);
        JSONObject orderInfo = this.orderInfo(order);
        return orderInfo;
    }

    public Map<String, Object> query(String tradeNo, String outTradeNo) {
        return this.query(new AssistOrder(tradeNo, outTradeNo));
    }

    public Map<String, Object> query(AssistOrder assistOrder) {
        String apbNonce = SignTextUtils.randomStr();
        TreeMap<String, String> data = new TreeMap<String, String>();
        data.put("access_token", ((WxYouDianPayConfigStorage)this.payConfigStorage).getAccessToken());
        if (StringUtils.isEmpty((CharSequence)assistOrder.getTradeNo())) {
            data.put("order_sn", assistOrder.getOutTradeNo());
        } else {
            data.put("order_sn", assistOrder.getTradeNo());
        }
        String sign = this.createSign(SignTextUtils.parameterText(data, (String)"") + apbNonce, ((WxYouDianPayConfigStorage)this.payConfigStorage).getInputCharset());
        String queryParam = SignTextUtils.parameterText(data) + "&apb_nonce=" + apbNonce + "&sign=" + sign;
        JSONObject jsonObject = this.execute(this.getReqUrl(YoudianTransactionType.NATIVE_STATUS) + "?" + queryParam, MethodType.GET, null);
        return jsonObject;
    }

    public Map<String, Object> close(String tradeNo, String outTradeNo) {
        return Collections.emptyMap();
    }

    public Map<String, Object> close(AssistOrder assistOrder) {
        return Collections.emptyMap();
    }

    public RefundResult refund(RefundOrder refundOrder) {
        String apbNonce = SignTextUtils.randomStr();
        TreeMap<String, String> data = new TreeMap<String, String>();
        data.put("access_token", ((WxYouDianPayConfigStorage)this.payConfigStorage).getAccessToken());
        if (StringUtils.isEmpty((CharSequence)refundOrder.getOutTradeNo())) {
            data.put("order_sn", refundOrder.getOutTradeNo());
        } else {
            data.put("order_sn", refundOrder.getTradeNo());
        }
        data.put("type", "4");
        data.put("refund_fee", refundOrder.getRefundAmount().setScale(2, 4).toString());
        String sign = this.createSign(SignTextUtils.parameterText(data, (String)"") + apbNonce, ((WxYouDianPayConfigStorage)this.payConfigStorage).getInputCharset());
        String queryParam = SignTextUtils.parameterText(data) + "&apb_nonce=" + apbNonce + "&sign=" + sign;
        JSONObject jsonObject = this.execute(this.getReqUrl(YoudianTransactionType.REFUND) + "?" + queryParam, MethodType.GET, null);
        return new BaseRefundResult((Map)jsonObject){

            public String getCode() {
                return this.getAttrString("errorcode");
            }

            public String getMsg() {
                return this.getAttrString("msg");
            }

            public String getResultCode() {
                return null;
            }

            public String getResultMsg() {
                return null;
            }

            public BigDecimal getRefundFee() {
                return null;
            }

            public CurType getRefundCurrency() {
                return null;
            }

            public String getTradeNo() {
                return null;
            }

            public String getOutTradeNo() {
                return null;
            }

            public String getRefundNo() {
                return null;
            }
        };
    }

    public Map<String, Object> refundquery(RefundOrder refundOrder) {
        return Collections.emptyMap();
    }

    public Map<String, Object> downloadBill(Date billDate, BillType billType) {
        return Collections.emptyMap();
    }

    public WxYouDianPayService(WxYouDianPayConfigStorage payConfigStorage) {
        super((PayConfigStorage)payConfigStorage);
    }

    public WxYouDianPayService(WxYouDianPayConfigStorage payConfigStorage, HttpConfigStorage configStorage) {
        super((PayConfigStorage)payConfigStorage, configStorage);
    }

    public String getReqUrl(TransactionType type) {
        return URL + type.getMethod();
    }

    public PayMessage createMessage(Map<String, Object> message) {
        return WxYoudianPayMessage.create(message);
    }
}

