package com.fasc.open.api.v5_1.client;

import com.fasc.open.api.bean.base.BaseRes;
import com.fasc.open.api.constants.OpenApiUrlConstants;
import com.fasc.open.api.exception.ApiException;
import com.fasc.open.api.v5_1.req.billing.GetBillListReq;
import com.fasc.open.api.v5_1.req.billing.GetBillSummaryListReq;
import com.fasc.open.api.v5_1.req.billing.GetOrderDetailReq;
import com.fasc.open.api.v5_1.req.billing.GetUsageListReq;
import com.fasc.open.api.v5_1.res.billing.GetBillListRes;
import com.fasc.open.api.v5_1.res.billing.GetBillSummaryListRes;
import com.fasc.open.api.v5_1.res.billing.GetOrderDetailRes;
import com.fasc.open.api.v5_1.res.billing.GetUsageListRes;

import java.util.List;

/**
 * @author Fadada
 * 2023/06/14 16:48:09
 */
public class BillAccountClient {

    private OpenApiClient openApiClient;

    public BillAccountClient(OpenApiClient openApiClient) {
        this.openApiClient = openApiClient;
    }


    public BaseRes<List<GetUsageListRes>> getUsageList(GetUsageListReq req) throws ApiException {
        return openApiClient.invokeApiList(req, OpenApiUrlConstants.BILL_ACCOUNT_GET_USAGE_LIST, GetUsageListRes.class);
    }

    public BaseRes<GetBillSummaryListRes> getBillSummaryList(GetBillSummaryListReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.BILL_ACCOUNT_GET_BILL_SUMMARY_LIST, GetBillSummaryListRes.class);
    }

    public BaseRes<GetBillListRes> getBillList(GetBillListReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.BILL_ACCOUNT_GET_BILL_LIST, GetBillListRes.class);
    }
    public BaseRes<GetOrderDetailRes> getOrderDetail(GetOrderDetailReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.BILL_ACCOUNT_GET_ORDER_DETAIL, GetOrderDetailRes.class);
    }

}
