package com.fasc.open.api.v5_1.client;

import com.fasc.open.api.bean.base.BaseRes;
import com.fasc.open.api.constants.OpenApiUrlConstants;
import com.fasc.open.api.exception.ApiException;
import com.fasc.open.api.v5_1.req.signtask.*;
import com.fasc.open.api.v5_1.res.signtask.*;

import java.util.List;

/**
 * @author Fadada
 * 2021/9/13 17:10:09
 */
public class SignTaskClient {
    private OpenApiClient openApiClient;

    public SignTaskClient(OpenApiClient openApiClient) {
        this.openApiClient = openApiClient;
    }

    public BaseRes<CreateSignTaskRes> create(CreateSignTaskReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_CREATE, CreateSignTaskRes.class);
    }

    public BaseRes<CreateSignTaskRes> createWithTemplate(CreateWithTemplateReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_CREATE_WITH_TEMPLATE, CreateSignTaskRes.class);
    }

    public BaseRes<Void> addDoc(AddDocReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_DOC_ADD, Void.class);
    }

    public BaseRes<Void> deleteDoc(DeleteDocReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_DOC_DELETE, Void.class);
    }

    public BaseRes<Void> addField(AddFieldReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_FIELD_ADD, Void.class);
    }

    public BaseRes<Void> deleteField(DeleteFieldReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_FIELD_DELETE, Void.class);
    }

    public BaseRes<Void> addAttach(AddAttachReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_ATTACH_ADD, Void.class);
    }

    public BaseRes<Void> deleteAttach(DeleteAttachReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_ATTACH_DELETE, Void.class);
    }

    public BaseRes<Void> addActor(AddActorsReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_ACTOR_ADD, Void.class);
    }

    public BaseRes<Void> signTaskActorRemove(SignTaskActorRemoveReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_ACTOR_REMOVE, Void.class);
    }
    public BaseRes<Void> deleteActor(DeleteActorReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_ACTOR_DELETE, Void.class);
    }

    public BaseRes<Void> start(SignTaskBaseReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_START, Void.class);
    }

    public BaseRes<Void> fillFieldValues(FillFieldValuesReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_FIELD_FILL_VALUES, Void.class);
    }
    public BaseRes<Void> deleteFieldValues(DeleteFieldValuesReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_FIELD_DELETE_VALUES, Void.class);
    }

    public BaseRes<Void> finalizeDoc(SignTaskBaseReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_DOC_FINALIZE, Void.class);
    }

    public BaseRes<Void> block(BlockReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_BLOCK, Void.class);
    }

    public BaseRes<Void> unblock(UnblockReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_UNBLOCK, Void.class);
    }

    public BaseRes<Void> cancel(SignTaskCancelReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_CANCEL, Void.class);
    }

    public BaseRes<SignTaskDetailRes> getDetail(SignTaskBaseReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_GET_DETAIL, SignTaskDetailRes.class);
    }

    public BaseRes<SignTaskDetailRes> querySignTaskDetail(QuerySignTaskDetailReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.QUERY_SIGN_TASK_DETAIL, SignTaskDetailRes.class);
    }

    public BaseRes<GetSignTaskListRes> getOwnerList(GetOwnerSignTaskListReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_OWNER_GET_LIST, GetSignTaskListRes.class);
    }

    public BaseRes<OwnerDownloadUrlRes> getOwnerDownloadUrl(GetOwnerDownloadUrlReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_OWNER_GET_DOWNLOAD_URL, OwnerDownloadUrlRes.class);
    }

    public BaseRes<SignTaskActorGetUrlRes> signTaskActorGetUrl(SignTaskActorGetUrlReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_ACTOR_GET_URL, SignTaskActorGetUrlRes.class);
    }

    public BaseRes<GetVerifyMethodsManageUrlRes> getSignVerifyMethodsManageUrl(GetVerifyMethodsManageUrlReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_INTENT_MANAGE_URL, GetVerifyMethodsManageUrlRes.class);
    }

    public BaseRes<List<SignTaskCatalogListRes>> signTaskCataloglist(SignTaskCatalogListReq req) throws ApiException {
        return openApiClient.invokeApiList(req, OpenApiUrlConstants.SIGN_TASK_CATALOG_LIST, SignTaskCatalogListRes.class);
    }

    public BaseRes<ListSignTaskFieldRes> listSignTaskField(ListSignTaskFieldReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_FIELD_LIST, ListSignTaskFieldRes.class);
    }

    public BaseRes<List<ListSignTaskActorRes>> listSignTaskActor(ListSignTaskActorReq req) throws ApiException {
        return openApiClient.invokeApiList(req, OpenApiUrlConstants.SIGN_TASK_ACTOR_LIST, ListSignTaskActorRes.class);
    }

    public BaseRes<GetApprovalInfoRes> getApprovalInfo(GetApprovalInfoReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_GET_APPROVAL_INFO, GetApprovalInfoRes.class);
    }

    public BaseRes<BatchSignUrlRes> getBatchSignUrl(GetBatchSignUrlReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_GET_BATCH_SIGN_URL, BatchSignUrlRes.class);
    }

    public BaseRes<GetSignTaskManageUrlRes> getBatchSignUrl(GetSignTaskManageUrlReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_GET_MANAGE_URL, GetSignTaskManageUrlRes.class);
    }

    public BaseRes<SignTaskBatchCreateGetUrlRes> signTaskBatchCreateGetUrl(SignTaskBatchCreateGetUrlReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_GET_BATCH_CREATE_URL, SignTaskBatchCreateGetUrlRes.class);
    }

    public BaseRes<SignTemplateBatchCreateGetDownloadUrlRes> signTemplateBatchCreateGetDownloadUrl(SignTemplateBatchCreateGetDownloadUrlReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_TEMPLATE_GET_BATCH_DOWNLOAD_URL, SignTemplateBatchCreateGetDownloadUrlRes.class);
    }

    public BaseRes<GetSignTaskEditUrlRes> getSignTaskEditUrl(GetSignTaskUrlReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_GET_EDIT_URL, GetSignTaskEditUrlRes.class);
    }

    public BaseRes<GetSignTaskPreviewUrlRes> getSignTaskPreviewUrl(GetSignTaskUrlReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_GET_PREVIEW_URL, GetSignTaskPreviewUrlRes.class);
    }

    public BaseRes<Void> signTaskUrge(SignTaskBaseReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_URGE, Void.class);
    }

    /**
     * 获取签署任务公证处保全报告
     **/
    public BaseRes<GetDownloadEvidenceReportRes> getDownloadEvidenceReport(GetDownloadEvidenceReportUrlReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.GET_SIGN_TASK_DOWNLOAD_EVIDENCE_REPORT_URL, GetDownloadEvidenceReportRes.class);
    }

    /**
     * 删除签署任务
     **/
    public BaseRes<Void> signTaskDelete(DeleteSignTaskReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_DELETE, Void.class);
    }

    /**
     * 结束签署任务
     **/
    public BaseRes<Void> signTaskFinish(FinishSignTaskReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_FINISH, Void.class);
    }

    /**
     * 查询签署业务类型列表
     **/
    public BaseRes<List<GetSignTaskBusinessTypeListRes>> getSignTaskBusinessTypeList(GetSignTaskBusinessTypeListReq req) throws ApiException {
        return openApiClient.invokeApiList(req, OpenApiUrlConstants.SIGN_TASK_GET_BUSINESS_TYPE_LIST, GetSignTaskBusinessTypeListRes.class);
    }

    /**
     * 创建签署业务类型
     **/
    public BaseRes<List<BatchAddBusinessTypesInfoRes>> createSignTaskBusinessType(BatchAddSignTaskBusinessTypesReq req) throws ApiException {
        return openApiClient.invokeApiList(req, OpenApiUrlConstants.SIGN_TASK_CREATE_BUSINESS_TYPE, BatchAddBusinessTypesInfoRes.class);
    }


    /**
     * 删除签署业务类型
     **/
    public BaseRes<Void> deleteSignTaskBusinessType(DeleteSignTaskBusinessTypeReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_DELETE_BUSINESS_TYPE, Void.class);
    }


    /**
     * 查询参与方签署底图
     **/
    public BaseRes<GetSignTaskFacePictureRes> getSignTaskFacePicture(GetSignTaskFacePictureReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_ACTOR_GET_FACE_PICTURE, GetSignTaskFacePictureRes.class);
    }

    /**
     * 作废签署任务
     **/
    public BaseRes<CancelSignTaskCreateRes> abolishSignTask(CancelSignTaskCreateReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_ABOLISH, CancelSignTaskCreateRes.class);
    }

    /**
     * 签署文档切图
     **/
    public BaseRes<GetSignTaskPicDocTicketRes> getSignTaskOwnerSlicingTicketId(GetSignTaskSlicingDocReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.GET_SIGN_TASK_OWNER_SLICING_TICKET_ID, GetSignTaskPicDocTicketRes.class);
    }

    /**
     * 获取签署文档图片下载地址
     **/
    public BaseRes<GetSigntaskImgDownloadUrlRes> getSignTaskOwnerSlicingTicketId(GetSignTaskImgDownloadUrlReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.GET_SIGN_TASK_IMG_DOWNLOAD_URL, GetSigntaskImgDownloadUrlRes.class);
    }

    /**
     * 获取图片版签署文档下载地址
     **/
    public BaseRes<GetSignTaskDocRes> getSignTaskOwnerPicDownloadUrl(GetSignTaskPicDocTicketReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.GET_SIGN_TASK_OWNER_PIC_DOWNLOAD_URL, GetSignTaskDocRes.class);
    }

    /**
     * 获取参与方签署音视频下载地址
     **/
    public BaseRes<GetActorAudioVideoRes> getAudioVideoDownloadUrl(GetActorAudioVideoReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.GET_AUDIO_VIDEO_DOWNLOAD_URL, GetActorAudioVideoRes.class);
    }

    /**
     * 获取V3签署任务链接
     **/
    public BaseRes<GetV3ActorSignTaskUrlRes> signTaskActorV3GetUrl(GetV3ActorSignTaskUrlReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_ACTOR_V3_GET_URL, GetV3ActorSignTaskUrlRes.class);
    }

    /**
     * 修改签署任务参与方
     **/
    public BaseRes<Void> modifyActor(ModifyActorReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_MODIFY_ACTOR, Void.class);
    }

    /**
     * 签署任务延期
     **/
    public BaseRes<Void> signTaskExtension(ExtensionReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_EXTENSION, Void.class);
    }

    /**
     * 签署任务驳回填写
     **/
    public BaseRes<Void> signTaskIgnore(SignTaskIgnoreReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_FIELD_IGNORE, Void.class);
    }

    public BaseRes<Void> signTaskFieldSubmit(FillInActorInfoReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_FIELD_SUBMIT, Void.class);
    }

    /**
     * 获取送达查看报告下载地址
     **/
    public BaseRes<GetSignTaskReportUrlRes> signTaskMessageReportGetDownloadUrl(GetSignTaskReportUrlReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_MESSAGE_REPORT_GET_DOWNLOAD_URL, GetSignTaskReportUrlRes.class);
    }

    /**
     * 获取预填充链接
     **/
    public BaseRes<SignTaskPreFillUrlRes> signTaskGetPrefillUrl(SignTaskPreFillUrlReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_GET_PREFILL_URL, SignTaskPreFillUrlRes.class);
    }

    /**
     * 查询签署完成的文件
     **/
    public BaseRes<SignTaskGetFileRes> signTaskGetFile(SignTaskGetFileReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_GET_FILE, SignTaskGetFileRes.class);
    }

    /**
     * 证据报告申请
     **/
    public BaseRes<SignTaskApplyReportRes> applyReport(SignTaskApplyReportReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_APPLY_REPORT, SignTaskApplyReportRes.class);
    }

    /**
     * 证据报告下载
     **/
    public BaseRes<SignTaskDownloadReportRes> downloadReport(SignTaskDownloadReportReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_DOWNLOAD_REPORT, SignTaskDownloadReportRes.class);
    }

    public BaseRes<GetLawyerLetterListRes> getLegalLetterList(GetLawyerLetterListReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_LEGAL_LETTER_LIST, GetLawyerLetterListRes.class);
    }

    /**
     * 获取证书信息
     **/
    public BaseRes<SignTaskGetCerInfoRes> getCerInfo(SignTaskGetCerInfoReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_GET_CER_INFO, SignTaskGetCerInfoRes.class);
    }

    /**
     * 获取二要素批量快捷签链接
     */
    public BaseRes<GetTwoElementBatchSignUrlRes> getTwoElementBatchSignUrl(GetTwoElementBatchSignUrlReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_TWO_ELEMENT_GET_BATCH_SIGN_URL, GetTwoElementBatchSignUrlRes.class);
    }

    /**
     * 删除签署文档副本
     * @param req
     * @return
     * @throws ApiException
     */
    public BaseRes<Void> signTaskFileDelete(SignTaskFileDeleteReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_FILE_DELETE, Void.class);
    }

    /**
     *SES创建任务
     * @param req
     * @return
     * @throws ApiException
     */
    public BaseRes<CreateSignTaskRes> sesCreateSignTask(SesSignTaskCreateReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SES_SIGN_TASK_CREATE, CreateSignTaskRes.class);
    }

    /**
     * ses获取编辑链接
     * @param req
     * @return
     * @throws ApiException
     */
    public BaseRes<GetSignTaskEditUrlRes> getSesSignTaskEditUrl(SesGetSignTaskUrlReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SES_SIGN_TASK_GET_EDIT_URL, GetSignTaskEditUrlRes.class);
    }

    public BaseRes<GetSesSignTaskActorUrlRes> getSesSignTaskActorUrl(GetSesSignTaskActorUrlReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SES_SIGN_TASK_GET_ACTOR_URL, GetSesSignTaskActorUrlRes.class);
    }

    /**
     * ses任务列表
     * @param req
     * @return
     * @throws ApiException
     */
    public BaseRes<SesGetSignTaskListRes> sesGetSignTaskList(SesGetSignTaskListReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SES_SIGN_TASK_LIST, SesGetSignTaskListRes.class);
    }

    /**
     * ses任务详情
     * @param req
     * @return
     * @throws ApiException
     */
    public BaseRes<SesSignTaskDetailRes> sesGetSignTaskDetail(SesSignTaskDetailReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SES_SIGN_TASK_DETAIL, SesSignTaskDetailRes.class);
    }

    /**
     * 获取SES签署任务审计报告
     * @param req
     * @return
     * @throws ApiException
     */
    public BaseRes<SesSignTaskReportDownloadUrlRes> sesGetSignTaskReportDownloadUrl(SesSignTaskReportDownLoadUrlReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SES_SIGN_TASK_DOWN_LOAD_REPORT_URL, SesSignTaskReportDownloadUrlRes.class);
    }

    /**
     * 获取SES签署任务批量签署签署链接
     * @param req
     * @return
     * @throws ApiException
     */
    public BaseRes<GetSesBatchSignTaskUrlRes> getSesBatchSignTaskUrl(GetSesBatchSignTaskUrlReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SES_SIGN_TASK_GET_BATCH_URL, GetSesBatchSignTaskUrlRes.class);
    }


    public BaseRes<CreateScanCodeSignTaskRes> createScanCodeSignTaskByTemplate(ScanCodeSignTaskCreateReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SCAN_CODE_SIGN_TASK_CREATE_WITH_TEMPLATE, CreateScanCodeSignTaskRes.class);
    }

    public BaseRes<Void> fillScanCodeSignTaskFieldValues(ScanCodeSignTaskFillValueReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SCAN_CODE_SIGN_TASK_FILL_VALUES, Void.class);
    }

    public BaseRes<Void> submitScanCodeSignTask(BaseScanCodeSignTaskReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SCAN_CODE_SIGN_TASK_START, Void.class);
    }

    public BaseRes<ScanCodeSignTaskDetailRes> getScanCodeSignTaskDetail(BaseScanCodeSignTaskReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SCAN_CODE_SIGN_TASK_DETAIL, ScanCodeSignTaskDetailRes.class);
    }

}
