package com.fasc.open.api.v5_1.res.seal;

import com.fasc.open.api.bean.base.BasePageRes;

import java.util.List;

/**
 * @Author： zhupintian
 * @Date: 2022/10/8
 */
public class GetSealInfoListRes extends BasePageRes {
	private List<SealBaseInfo> sealInfos;

	public List<SealBaseInfo> getSealInfos() {
		return sealInfos;
	}

	public void setSealInfos(List<SealBaseInfo> sealInfos) {
		this.sealInfos = sealInfos;
	}

	public static class SealBaseInfo{
		/**
		 * 印章ID，只有系统生成或审核通过的印章才返回
		 */
		private Long sealId;

		/**
		 * 成员企业主体ID
		 */
		private String entityId;

		/**
		 * 该印章在归属主体在企业账号下的类型
		 */
		private String entityType;

		/**
		 * 印章名称
		 */
		private String sealName;

		private String picFileUrl;

		/**
		 * 印章标签
		 */
		private String sealTag;

		/**
		 * 印章类型：official_seal-法定名称章（公章）, contract_seal-合同专用章, hr_seal-人事专用章, financial_seal-财务专用章, legal_representative_seal-法定代表人名章, other-其他
		 */
		private String categoryType;

		/**
		 * 印章宽，单位毫米mm
		 */
		private Integer sealWidth;

		/**
		 * 印章高，单位毫米m
		 */
		private Integer sealHeight;

		/**
		 * 印章状态，只有系统生成或审核通过的印章才返回：enable-已启用, disable-已停用, cancelled-已注销
		 */
		private String sealStatus;

		/**
		 * 印章创建时间，精确到毫秒
		 */
		private String createTime;

		//制作方式
		private String createMethod ;

		/**
		 * 印章审核ID，需要法大大审核的印章才会返回
		 */
		private Long verifyId;

		public Long getSealId() {
			return sealId;
		}

		public void setSealId(Long sealId) {
			this.sealId = sealId;
		}

		public String getEntityId() {
			return entityId;
		}

		public void setEntityId(String entityId) {
			this.entityId = entityId;
		}

		public String getEntityType() {
			return entityType;
		}

		public void setEntityType(String entityType) {
			this.entityType = entityType;
		}

		public String getSealName() {
			return sealName;
		}

		public void setSealName(String sealName) {
			this.sealName = sealName;
		}

		public String getPicFileUrl() {
			return picFileUrl;
		}

		public void setPicFileUrl(String picFileUrl) {
			this.picFileUrl = picFileUrl;
		}

		public String getSealTag() {
			return sealTag;
		}

		public void setSealTag(String sealTag) {
			this.sealTag = sealTag;
		}

		public String getCategoryType() {
			return categoryType;
		}

		public void setCategoryType(String categoryType) {
			this.categoryType = categoryType;
		}

		public Integer getSealWidth() {
			return sealWidth;
		}

		public void setSealWidth(Integer sealWidth) {
			this.sealWidth = sealWidth;
		}

		public Integer getSealHeight() {
			return sealHeight;
		}

		public void setSealHeight(Integer sealHeight) {
			this.sealHeight = sealHeight;
		}

		public String getSealStatus() {
			return sealStatus;
		}

		public void setSealStatus(String sealStatus) {
			this.sealStatus = sealStatus;
		}

		public String getCreateTime() {
			return createTime;
		}

		public void setCreateTime(String createTime) {
			this.createTime = createTime;
		}

		public String getCreateMethod() {
			return createMethod;
		}

		public void setCreateMethod(String createMethod) {
			this.createMethod = createMethod;
		}

		public Long getVerifyId() {
			return verifyId;
		}

		public void setVerifyId(Long verifyId) {
			this.verifyId = verifyId;
		}
	}
}
