/*
 * Decompiled with CFR 0.152.
 */
package com.fasc.open.api.v5_1.client;

import com.fasc.open.api.bean.base.BaseRes;
import com.fasc.open.api.exception.ApiException;
import com.fasc.open.api.v5_1.client.OpenApiClient;
import com.fasc.open.api.v5_1.req.smartform.DeleteSmartFormReq;
import com.fasc.open.api.v5_1.req.smartform.DeleteSmartFormSerialReq;
import com.fasc.open.api.v5_1.req.smartform.GetSmartFormCollectUrlReq;
import com.fasc.open.api.v5_1.req.smartform.GetSmartFormDetailReq;
import com.fasc.open.api.v5_1.req.smartform.GetSmartFormListReq;
import com.fasc.open.api.v5_1.req.smartform.GetSmartFormManageUrlReq;
import com.fasc.open.api.v5_1.req.smartform.GetSmartFormSerialInfoReq;
import com.fasc.open.api.v5_1.res.smartform.GetSmartFormCollectUrlRes;
import com.fasc.open.api.v5_1.res.smartform.GetSmartFormDetailRes;
import com.fasc.open.api.v5_1.res.smartform.GetSmartFormListRes;
import com.fasc.open.api.v5_1.res.smartform.GetSmartFormManageUrlRes;
import com.fasc.open.api.v5_1.res.smartform.GetSmartFormSerialInfoRes;
import java.util.List;

public class SmartFormClient {
    private OpenApiClient openApiClient;

    public SmartFormClient(OpenApiClient openApiClient) {
        this.openApiClient = openApiClient;
    }

    public BaseRes<List<GetSmartFormListRes>> list(GetSmartFormListReq req) throws ApiException {
        return this.openApiClient.invokeApiList(req, "POST /smartform/get-list", GetSmartFormListRes.class);
    }

    public BaseRes<GetSmartFormDetailRes> detail(GetSmartFormDetailReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /smartform/get-detail", GetSmartFormDetailRes.class);
    }

    public BaseRes<List<GetSmartFormSerialInfoRes>> getSmartFormSerialInfo(GetSmartFormSerialInfoReq req) throws ApiException {
        return this.openApiClient.invokeApiList(req, "POST /smartform/serial/get-info", GetSmartFormSerialInfoRes.class);
    }

    public BaseRes<Void> deleteSmartForm(DeleteSmartFormReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /smartform/delete", Void.class);
    }

    public BaseRes<Void> deleteSmartFormSerial(DeleteSmartFormSerialReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /smartform/serial/delete", Void.class);
    }

    public BaseRes<GetSmartFormManageUrlRes> getSmartFormManageUrl(GetSmartFormManageUrlReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /smartform/manage/get-url", GetSmartFormManageUrlRes.class);
    }

    public BaseRes<GetSmartFormCollectUrlRes> getSmartFormCollectUrl(GetSmartFormCollectUrlReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /smartform/collect/get-url", GetSmartFormCollectUrlRes.class);
    }
}

