/*
 * Decompiled with CFR 0.152.
 */
package com.feiniaojin.gracefulresponse.advice;

import com.feiniaojin.gracefulresponse.advice.DefaultRejectStrategyImpl;
import com.feiniaojin.gracefulresponse.advice.lifecycle.exception.RejectStrategy;
import com.feiniaojin.gracefulresponse.advice.lifecycle.response.AfterResponseBodyAdviceProcess;
import com.feiniaojin.gracefulresponse.advice.lifecycle.response.BeforeResponseBodyAdviceProcess;
import com.feiniaojin.gracefulresponse.advice.lifecycle.response.ResponseBodyAdvicePredicate;
import com.feiniaojin.gracefulresponse.advice.lifecycle.response.ResponseBodyAdviceProcessor;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

public abstract class AbstractResponseBodyAdvice
implements ResponseBodyAdvice<Object> {
    private List<ResponseBodyAdvicePredicate> predicates = new CopyOnWriteArrayList<ResponseBodyAdvicePredicate>();
    private RejectStrategy rejectStrategy = new DefaultRejectStrategyImpl();
    private BeforeResponseBodyAdviceProcess beforeResponseBodyAdviceProcess;
    private AfterResponseBodyAdviceProcess afterResponseBodyAdviceProcess;
    private ResponseBodyAdviceProcessor responseBodyAdviceProcessor;

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        boolean hit = true;
        List<ResponseBodyAdvicePredicate> pList = this.predicates;
        for (ResponseBodyAdvicePredicate predicateBeforeHandle : pList) {
            if (predicateBeforeHandle.shouldApplyTo(returnType, converterType)) continue;
            hit = false;
            break;
        }
        return hit;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        if (Objects.nonNull(this.beforeResponseBodyAdviceProcess)) {
            this.beforeResponseBodyAdviceProcess.call(body, returnType, selectedContentType, selectedConverterType, request, response);
        }
        body = this.responseBodyAdviceProcessor.process(body, returnType, selectedContentType, selectedConverterType, request, response);
        if (Objects.nonNull(this.afterResponseBodyAdviceProcess)) {
            this.afterResponseBodyAdviceProcess.call(body, returnType, selectedContentType, selectedConverterType, request, response);
        }
        return body;
    }

    public List<ResponseBodyAdvicePredicate> getPredicates() {
        return this.predicates;
    }

    public void setPredicates(List<ResponseBodyAdvicePredicate> predicates) {
        this.predicates = predicates;
    }

    public RejectStrategy getRejectStrategy() {
        return this.rejectStrategy;
    }

    public void setRejectStrategy(RejectStrategy rejectStrategy) {
        this.rejectStrategy = rejectStrategy;
    }

    public BeforeResponseBodyAdviceProcess getBeforeResponseBodyAdviceProcess() {
        return this.beforeResponseBodyAdviceProcess;
    }

    public void setBeforeResponseBodyAdviceProcess(BeforeResponseBodyAdviceProcess beforeResponseBodyAdviceProcess) {
        this.beforeResponseBodyAdviceProcess = beforeResponseBodyAdviceProcess;
    }

    public AfterResponseBodyAdviceProcess getAfterResponseBodyAdviceProcess() {
        return this.afterResponseBodyAdviceProcess;
    }

    public void setAfterResponseBodyAdviceProcess(AfterResponseBodyAdviceProcess afterResponseBodyAdviceProcess) {
        this.afterResponseBodyAdviceProcess = afterResponseBodyAdviceProcess;
    }

    public ResponseBodyAdviceProcessor getResponseBodyAdviceProcessor() {
        return this.responseBodyAdviceProcessor;
    }

    public void setResponseBodyAdviceProcessor(ResponseBodyAdviceProcessor responseBodyAdviceProcessor) {
        this.responseBodyAdviceProcessor = responseBodyAdviceProcessor;
    }
}

