/*
 * Decompiled with CFR 0.152.
 */
package com.feiniaojin.gracefulresponse.advice;

import com.feiniaojin.gracefulresponse.GracefulResponseProperties;
import com.feiniaojin.gracefulresponse.api.ExcludeFromGracefulResponse;
import jakarta.annotation.Resource;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.AbstractJackson2HttpMessageConverter;
import org.springframework.http.converter.json.AbstractJsonHttpMessageConverter;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.CollectionUtils;

public class AdviceSupport {
    private final Logger logger = LoggerFactory.getLogger(AdviceSupport.class);
    private static final AntPathMatcher ANT_PATH_MATCHER = new AntPathMatcher();
    @Resource
    private GracefulResponseProperties properties;

    public boolean isJsonHttpMessageConverter(Class<? extends HttpMessageConverter<?>> clazz) {
        return AbstractJsonHttpMessageConverter.class.isAssignableFrom(clazz) || AbstractJackson2HttpMessageConverter.class.isAssignableFrom(clazz) || clazz.getName().equals(this.properties.getJsonHttpMessageConverter());
    }

    public boolean matchExcludeFromGracefulResponse(Method method) {
        if (method.isAnnotationPresent(ExcludeFromGracefulResponse.class)) {
            this.logger.debug("Graceful Response:\u65b9\u6cd5\u88ab@ExcludeFromGracefulResponse\u6ce8\u89e3\u4fee\u9970:methodName={}", (Object)method.getName());
            return true;
        }
        if (method.getDeclaringClass().isAnnotationPresent(ExcludeFromGracefulResponse.class)) {
            this.logger.debug("Graceful Response:\u7c7b\u88ab@ExcludeFromGracefulResponse\u6ce8\u89e3\u4fee\u9970:methodName={}", (Object)method.getName());
            return true;
        }
        if (method.getReturnType().isAnnotationPresent(ExcludeFromGracefulResponse.class)) {
            this.logger.debug("Graceful Response:\u8fd4\u56de\u7c7b\u578b\u88ab@ExcludeFromGracefulResponse\u6ce8\u89e3\u4fee\u9970:methodName={}", (Object)method.getName());
            return true;
        }
        return false;
    }

    public boolean isMatchExcludeException(Throwable throwable) {
        Class<?> aClass = throwable.getClass();
        Set<Class<?>> excludeExceptionTypes = this.properties.getExcludeExceptionTypes();
        if (!CollectionUtils.isEmpty(excludeExceptionTypes)) {
            if (excludeExceptionTypes.contains(aClass)) {
                return true;
            }
            Optional<Class> classOptional = excludeExceptionTypes.stream().filter(eClass -> eClass.isAssignableFrom(aClass)).findFirst();
            if (classOptional.isPresent()) {
                return true;
            }
        }
        String packageName = aClass.getPackageName();
        List<String> excludeExceptionPackages = this.properties.getExcludeExceptionPackages();
        if (!CollectionUtils.isEmpty(excludeExceptionPackages)) {
            for (String str : excludeExceptionPackages) {
                if (!ANT_PATH_MATCHER.match(str, packageName)) continue;
                return true;
            }
        }
        return false;
    }
}

