/*
 * Decompiled with CFR 0.152.
 */
package com.feiniaojin.gracefulresponse.advice;

import com.feiniaojin.gracefulresponse.advice.ReleaseMessageConverterMethodProcessor;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.MessageSource;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.lang.Nullable;
import org.springframework.ui.ModelMap;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.method.ControllerAdviceBean;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.method.annotation.ExceptionHandlerMethodResolver;
import org.springframework.web.method.annotation.MapMethodProcessor;
import org.springframework.web.method.annotation.ModelMethodProcessor;
import org.springframework.web.method.support.HandlerMethodArgumentResolverComposite;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.HandlerMethodReturnValueHandlerComposite;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.method.annotation.ExceptionHandlerExceptionResolver;
import org.springframework.web.servlet.mvc.method.annotation.HttpEntityMethodProcessor;
import org.springframework.web.servlet.mvc.method.annotation.ModelAndViewMethodReturnValueHandler;
import org.springframework.web.servlet.mvc.method.annotation.RequestResponseBodyMethodProcessor;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ServletInvocableHandlerMethod;
import org.springframework.web.servlet.mvc.method.annotation.ServletModelAttributeMethodProcessor;
import org.springframework.web.servlet.mvc.method.annotation.ViewMethodReturnValueHandler;
import org.springframework.web.servlet.mvc.method.annotation.ViewNameMethodReturnValueHandler;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.util.DisconnectedClientHelper;

public class ReleaseExceptionHandlerExceptionResolver
extends ExceptionHandlerExceptionResolver
implements ApplicationContextAware,
InitializingBean {
    public static final String RELEASE_EXCEPTION_KEY = "RELEASE_EXCEPTION_KEY";
    private final List<Object> responseBodyAdvice = new ArrayList<Object>();
    private final ContentNegotiationManager contentNegotiationManager = new ContentNegotiationManager();
    private final Map<ControllerAdviceBean, ExceptionHandlerMethodResolver> exceptionHandlerAdviceCache = new LinkedHashMap<ControllerAdviceBean, ExceptionHandlerMethodResolver>();
    private static final String DISCONNECTED_CLIENT_LOG_CATEGORY = "org.springframework.web.servlet.mvc.method.annotation.DisconnectedClient";
    private static final DisconnectedClientHelper DISCONNECTED_CLIENT_HELPER = new DisconnectedClientHelper("org.springframework.web.servlet.mvc.method.annotation.DisconnectedClient");
    @Resource
    private ApplicationContext applicationContext;
    @Nullable
    private HandlerMethodArgumentResolverComposite argumentResolvers;
    @Nullable
    private HandlerMethodReturnValueHandlerComposite returnValueHandlers;
    private final List<HttpMessageConverter<?>> messageConverters = new ArrayList();

    private void initExceptionHandlerAdviceCache0() {
        if (this.getApplicationContext() == null) {
            return;
        }
        ApplicationContext context = this.getApplicationContext();
        if (Objects.isNull(context)) {
            return;
        }
        List adviceBeans = ControllerAdviceBean.findAnnotatedBeans((ApplicationContext)context);
        for (ControllerAdviceBean adviceBean : adviceBeans) {
            Class beanType = adviceBean.getBeanType();
            if (beanType == null) {
                throw new IllegalStateException("Unresolvable type for ControllerAdviceBean: " + adviceBean);
            }
            ExceptionHandlerMethodResolver resolver = new ExceptionHandlerMethodResolver(beanType);
            if (resolver.hasExceptionMappings()) {
                this.exceptionHandlerAdviceCache.put(adviceBean, resolver);
            }
            if (!ResponseBodyAdvice.class.isAssignableFrom(beanType)) continue;
            this.responseBodyAdvice.add(adviceBean);
        }
        if (this.logger.isDebugEnabled()) {
            int handlerSize = this.exceptionHandlerAdviceCache.size();
            int adviceSize = this.responseBodyAdvice.size();
            if (handlerSize == 0 && adviceSize == 0) {
                this.logger.debug((Object)"ControllerAdvice beans: none");
            } else {
                this.logger.debug((Object)("ControllerAdvice beans: " + handlerSize + " @ExceptionHandler, " + adviceSize + " ResponseBodyAdvice"));
            }
        }
    }

    public void afterPropertiesSet() {
        this.initExceptionHandlerAdviceCache0();
        this.initMessageConverters0();
        if (this.argumentResolvers == null) {
            List resolvers = this.getDefaultArgumentResolvers();
            this.argumentResolvers = new HandlerMethodArgumentResolverComposite().addResolvers(resolvers);
        }
        if (this.returnValueHandlers == null) {
            List<HandlerMethodReturnValueHandler> handlers = this.getDefaultReturnValueHandlers();
            this.returnValueHandlers = new HandlerMethodReturnValueHandlerComposite().addHandlers(handlers);
        }
        this.returnValueHandlers.addHandler((HandlerMethodReturnValueHandler)new RequestResponseBodyMethodProcessor(this.messageConverters, this.getContentNegotiationManager(), this.responseBodyAdvice));
    }

    private void initMessageConverters0() {
        if (!this.messageConverters.isEmpty()) {
            return;
        }
        this.messageConverters.add((HttpMessageConverter<?>)new MappingJackson2HttpMessageConverter());
    }

    protected List<HandlerMethodReturnValueHandler> getDefaultReturnValueHandlers() {
        ArrayList<HandlerMethodReturnValueHandler> handlers = new ArrayList<HandlerMethodReturnValueHandler>();
        handlers.add((HandlerMethodReturnValueHandler)new ModelAndViewMethodReturnValueHandler());
        handlers.add((HandlerMethodReturnValueHandler)new ModelMethodProcessor());
        handlers.add((HandlerMethodReturnValueHandler)new ViewMethodReturnValueHandler());
        handlers.add((HandlerMethodReturnValueHandler)new HttpEntityMethodProcessor(this.getMessageConverters(), this.contentNegotiationManager, this.responseBodyAdvice));
        handlers.add((HandlerMethodReturnValueHandler)new ServletModelAttributeMethodProcessor(false));
        handlers.add((HandlerMethodReturnValueHandler)new RequestResponseBodyMethodProcessor(this.getMessageConverters(), this.contentNegotiationManager, this.responseBodyAdvice));
        handlers.add((HandlerMethodReturnValueHandler)new ViewNameMethodReturnValueHandler());
        handlers.add((HandlerMethodReturnValueHandler)new MapMethodProcessor());
        if (this.getCustomReturnValueHandlers() != null) {
            handlers.addAll(this.getCustomReturnValueHandlers());
        }
        handlers.add((HandlerMethodReturnValueHandler)new ReleaseMessageConverterMethodProcessor(this.getMessageConverters(), this.contentNegotiationManager, this.responseBodyAdvice));
        handlers.add((HandlerMethodReturnValueHandler)new ServletModelAttributeMethodProcessor(true));
        return handlers;
    }

    public List<HttpMessageConverter<?>> getMessageConverters() {
        return this.messageConverters;
    }

    @Nullable
    public ModelAndView doResolveHandlerMethodException(HttpServletRequest request, HttpServletResponse response, HandlerMethod handlerMethod, Exception exception) {
        ServletInvocableHandlerMethod exceptionHandlerMethod = this.getExceptionHandlerMethod(handlerMethod, exception);
        assert (exceptionHandlerMethod != null);
        if (this.argumentResolvers != null) {
            exceptionHandlerMethod.setHandlerMethodArgumentResolvers(this.argumentResolvers);
        }
        if (this.returnValueHandlers != null) {
            exceptionHandlerMethod.setHandlerMethodReturnValueHandlers(this.returnValueHandlers);
        }
        ServletWebRequest webRequest = new ServletWebRequest(request, response);
        ModelAndViewContainer mavContainer = new ModelAndViewContainer();
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Using @ExceptionHandler " + exceptionHandlerMethod));
            }
            Throwable exToExpose = exception;
            while (exToExpose != null) {
                exceptions.add((Exception)exToExpose);
                Throwable cause = exToExpose.getCause();
                exToExpose = cause != exToExpose ? cause : null;
            }
            Object[] arguments = new Object[exceptions.size() + 1];
            exceptions.toArray(arguments);
            arguments[arguments.length - 1] = handlerMethod;
            exceptionHandlerMethod.invokeAndHandle(webRequest, mavContainer, arguments);
        }
        catch (Exception invocationEx) {
            if (DISCONNECTED_CLIENT_HELPER.checkAndLogClientDisconnectedException((Throwable)invocationEx)) {
                return new ModelAndView();
            }
            if (!exceptions.contains(invocationEx) && this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("Failure in @ExceptionHandler " + exceptionHandlerMethod), (Throwable)invocationEx);
            }
            return null;
        }
        if (mavContainer.isRequestHandled()) {
            return new ModelAndView();
        }
        ModelMap model = mavContainer.getModel();
        HttpStatusCode status = mavContainer.getStatus();
        ModelAndView mav = new ModelAndView(mavContainer.getViewName(), (Map)model, status);
        mav.setViewName(mavContainer.getViewName());
        if (!mavContainer.isViewReference()) {
            mav.setView((View)mavContainer.getView());
        }
        if (model instanceof RedirectAttributes) {
            RedirectAttributes redirectAttributes = (RedirectAttributes)model;
            Map flashAttributes = redirectAttributes.getFlashAttributes();
            RequestContextUtils.getOutputFlashMap((HttpServletRequest)request).putAll(flashAttributes);
        }
        return mav;
    }

    protected ServletInvocableHandlerMethod getExceptionHandlerMethod(HandlerMethod handlerMethod, Exception exception) {
        assert (handlerMethod != null);
        return new ServletInvocableHandlerMethod(handlerMethod.getBean(), handlerMethod.getMethod(), (MessageSource)this.applicationContext);
    }
}

