/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.MarkOccurrencesHighlightPainter;
import org.fife.ui.rsyntaxtextarea.OccurrenceMarker;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaHighlighter;
import org.fife.ui.rsyntaxtextarea.Token;

class DefaultOccurrenceMarker
implements OccurrenceMarker {
    DefaultOccurrenceMarker() {
    }

    public void markOccurrences(RSyntaxDocument doc, Token t, RSyntaxTextAreaHighlighter h, MarkOccurrencesHighlightPainter p) {
        char[] lexeme = t.getLexeme().toCharArray();
        int type = t.getType();
        int lineCount = doc.getDefaultRootElement().getElementCount();
        for (int i = 0; i < lineCount; ++i) {
            for (Token temp = doc.getTokenListForLine(i); temp != null && temp.isPaintable(); temp = temp.getNextToken()) {
                if (!temp.is(type, lexeme)) continue;
                try {
                    int end = temp.getEndOffset();
                    h.addMarkedOccurrenceHighlight(temp.getOffset(), end, p);
                    continue;
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
            }
        }
    }
}

