/*
 * Decompiled with CFR 0.152.
 */
package com.flowlogix.ui;

import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import org.apache.commons.lang3.StringUtils;
import org.omnifaces.resourcehandler.DefaultResourceHandler;
import org.omnifaces.util.Faces;

public class MinimizedHandler
extends DefaultResourceHandler {
    private final Pattern alreadyMinimizedPattern;
    private final Pattern extensionsPattern;
    private final String replacementMatchPattern;
    private final String replacementString;

    public MinimizedHandler(ResourceHandler wrapped) {
        this(wrapped, Optional.ofNullable(Faces.getExternalContext().getInitParameter("com.flowlogix.MINIMIZED_PREFIX")).orElse("min"), MinimizedHandler.parseExtensions(Optional.ofNullable(Faces.getExternalContext().getInitParameter("com.flowlogix.MINIMIZED_FILE_TYPES")).orElse("css, js")));
    }

    MinimizedHandler(ResourceHandler wrapped, String minimizedPrefix, Set<String> minimizedExtensions) {
        super(wrapped);
        this.alreadyMinimizedPattern = Pattern.compile(String.format(".*\\.%s\\.(%s)$", minimizedPrefix, String.join((CharSequence)"|", minimizedExtensions)));
        this.extensionsPattern = Pattern.compile(String.format(".*\\.(%s)$", String.join((CharSequence)"|", minimizedExtensions)));
        this.replacementMatchPattern = String.format("(.*)(%s)$", minimizedExtensions.stream().map(str -> "\\.".concat((String)str)).collect(Collectors.joining("|")));
        this.replacementString = String.format("$1.%s$2", minimizedPrefix);
    }

    public Resource decorateResource(Resource resource) {
        if (resource != null && !Faces.isDevelopment() && resource.getLibraryName() == null) {
            resource.setResourceName(this.toMinimized(resource.getResourceName()));
        }
        return resource;
    }

    String toMinimized(String resourceName) {
        if (!this.alreadyMinimizedPattern.matcher(resourceName).matches() && this.extensionsPattern.matcher(resourceName).matches()) {
            return resourceName.replaceFirst(this.replacementMatchPattern, this.replacementString);
        }
        return resourceName;
    }

    static Set<String> parseExtensions(String extensions) {
        return Stream.of(StringUtils.split((String)extensions, (String)", ")).collect(Collectors.toSet());
    }
}

