/*
 * Decompiled with CFR 0.152.
 */
package com.flowlogix.util;

import com.flowlogix.util.JakartaTransformerUtils;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.function.Consumer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import lombok.Generated;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.omnifaces.util.Lazy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ShrinkWrapManipulator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShrinkWrapManipulator.class);
    public static final String INTEGRATION_TEST_MODE_PROPERTY = "integration.test.mode";
    public static final String CLIENT_STATE_SAVING = "clientStateSaving";
    public static final String SHIRO_NATIVE_SESSIONS = "shiroNativeSessions";
    public static final String SHIRO_EE_DISABLED = "disableShiroEE";
    static final String DEFAULT_SSL_PROPERTY = "sslPort";
    static final int DEFAULT_SSL_PORT = 8181;
    private static final List<Action> standardActions = ShrinkWrapManipulator.initializeStandardActions();
    private final Lazy<DocumentBuilder> builder = new Lazy(this::createDocumentBuilder);
    private final Lazy<Transformer> transformer = new Lazy(this::createTransformer);

    public void webXmlXPath(WebArchive archive, List<Action> actions) {
        Document webXml;
        try (InputStream strm = archive.get("WEB-INF/web.xml").getAsset().openStream();){
            webXml = ((DocumentBuilder)this.builder.get()).parse(strm);
        }
        XPath xpath = XPathFactory.newInstance().newXPath();
        for (Action action : actions) {
            XPathExpression expr = xpath.compile(action.path);
            Node node = (Node)expr.evaluate(webXml, XPathConstants.NODE);
            if (node == null && action.optional) {
                log.debug("Optional path {} ignored", (Object)action.path);
                continue;
            }
            action.func.accept(node);
        }
        StringWriter writer = new StringWriter();
        ((Transformer)this.transformer.get()).transform(new DOMSource(webXml), new StreamResult(writer));
        String newXmlText = writer.getBuffer().toString();
        archive.setWebXML((Asset)new StringAsset(newXmlText));
    }

    public static boolean isClientStateSavingIntegrationTest() {
        return CLIENT_STATE_SAVING.equals(System.getProperty(INTEGRATION_TEST_MODE_PROPERTY));
    }

    public static boolean isShiroNativeSessionsIntegrationTest() {
        return SHIRO_NATIVE_SESSIONS.equals(System.getProperty(INTEGRATION_TEST_MODE_PROPERTY));
    }

    public static URL toHttpsURL(URL httpUrl) {
        return ShrinkWrapManipulator.toHttpsURL(httpUrl, DEFAULT_SSL_PROPERTY, 8181);
    }

    public static URL toHttpsURL(URL httpUrl, String sslPortPropertyName, int defaultPort) {
        if (httpUrl.getProtocol().endsWith("s")) {
            return httpUrl;
        }
        int sslPort = Integer.getInteger(sslPortPropertyName, defaultPort);
        return new URI(httpUrl.getProtocol() + "s", null, httpUrl.getHost(), sslPort, httpUrl.getPath(), null, null).toURL();
    }

    public static String getContextParamValue(String paramName) {
        return String.format("//web-app/context-param[param-name = '%s']/param-value", paramName);
    }

    private static List<Action> initializeStandardActions() {
        switch (System.getProperty(INTEGRATION_TEST_MODE_PROPERTY, "none")) {
            case "clientStateSaving": {
                return List.of(new Action(ShrinkWrapManipulator.getContextParamValue(JakartaTransformerUtils.jakartify("javax.faces.STATE_SAVING_METHOD")), node -> node.setTextContent("client")));
            }
            case "shiroNativeSessions": {
                return List.of(new Action(ShrinkWrapManipulator.getContextParamValue("shiroConfigLocations"), node -> node.setTextContent(node.getTextContent() + ",classpath:META-INF/shiro-native-sessions.ini")));
            }
            case "disableShiroEE": {
                return List.of(new Action(ShrinkWrapManipulator.getContextParamValue("com.flowlogix.shiro.ee.disabled"), node -> node.setTextContent("true"), true), new Action(ShrinkWrapManipulator.getContextParamValue("org.apache.shiro.ee.disabled"), node -> node.setTextContent("true"), true));
            }
        }
        return List.of();
    }

    private DocumentBuilder createDocumentBuilder() {
        return DocumentBuilderFactory.newInstance().newDocumentBuilder();
    }

    private Transformer createTransformer() {
        return TransformerFactory.newInstance().newTransformer();
    }

    @Generated
    public static List<Action> getStandardActions() {
        return standardActions;
    }

    public static class Action {
        private final String path;
        private final Consumer<Node> func;
        private final boolean optional;

        public Action(String path, Consumer<Node> func) {
            this(path, func, false);
        }

        @ConstructorProperties(value={"path", "func", "optional"})
        @Generated
        public Action(String path, Consumer<Node> func, boolean optional) {
            this.path = path;
            this.func = func;
            this.optional = optional;
        }
    }
}

