/*
 * Decompiled with CFR 0.152.
 */
package com.fujieid.jap.core.cache;

import cn.hutool.core.util.StrUtil;
import com.fujieid.jap.core.cache.JapCache;
import com.fujieid.jap.core.cache.JapCacheConfig;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class JapLocalCache
implements JapCache,
Serializable {
    private static final Map<String, CacheObj> LOCAL_CACHE = new ConcurrentHashMap<String, CacheObj>();
    private final ReentrantReadWriteLock cacheLock = new ReentrantReadWriteLock(true);
    private final Lock writeLock = this.cacheLock.writeLock();
    private final Lock readLock = this.cacheLock.readLock();

    public JapLocalCache() {
        if (JapCacheConfig.schedulePrune) {
            this.schedulePrune(JapCacheConfig.timeout);
        }
    }

    @Override
    public void set(String key, Serializable value) {
        this.set(key, value, JapCacheConfig.timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(String key, Serializable value, long timeout) {
        this.writeLock.lock();
        try {
            LOCAL_CACHE.put(key, new CacheObj(value, timeout));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Serializable get(String key) {
        if (StrUtil.isEmpty((CharSequence)key)) {
            return null;
        }
        this.readLock.lock();
        try {
            CacheObj cacheObj = LOCAL_CACHE.get(key);
            if (null == cacheObj || cacheObj.isExpired()) {
                Serializable serializable = null;
                return serializable;
            }
            Serializable serializable = cacheObj.getData();
            return serializable;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(String key) {
        if (StrUtil.isEmpty((CharSequence)key)) {
            return false;
        }
        this.readLock.lock();
        try {
            CacheObj cacheObj = LOCAL_CACHE.get(key);
            boolean bl = null != cacheObj && !cacheObj.isExpired();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void removeKey(String key) {
        this.writeLock.lock();
        try {
            LOCAL_CACHE.remove(key);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void schedulePrune(long delay) {
        AuthCacheScheduler.INSTANCE.schedule(this::pruneCache, delay);
    }

    public void pruneCache() {
        Iterator<CacheObj> values = LOCAL_CACHE.values().iterator();
        while (values.hasNext()) {
            CacheObj cacheObj = values.next();
            if (!cacheObj.isExpired()) continue;
            values.remove();
        }
    }

    private static class CacheObj
    implements Serializable {
        private final Serializable data;
        private final long expire;

        CacheObj(Serializable data, long expire) {
            this.data = data;
            this.expire = System.currentTimeMillis() + expire;
        }

        boolean isExpired() {
            return System.currentTimeMillis() > this.expire;
        }

        public Serializable getData() {
            return this.data;
        }

        public long getExpire() {
            return this.expire;
        }
    }

    private static enum AuthCacheScheduler {
        INSTANCE;

        private final AtomicInteger cacheTaskNumber = new AtomicInteger(1);
        private ScheduledExecutorService scheduler;

        private AuthCacheScheduler() {
            this.create();
        }

        private void create() {
            this.shutdown();
            this.scheduler = new ScheduledThreadPoolExecutor(10, r -> new Thread(r, String.format("JustAuth-Task-%s", this.cacheTaskNumber.getAndIncrement())));
        }

        public void shutdown() {
            if (null != this.scheduler) {
                this.scheduler.shutdown();
            }
        }

        public void schedule(Runnable task, long delay) {
            this.scheduler.scheduleAtFixedRate(task, delay, delay, TimeUnit.MILLISECONDS);
        }
    }
}

