/*
 * Decompiled with CFR 0.152.
 */
package com.fujieid.jap.core.context;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import com.fujieid.jap.core.JapUser;
import com.fujieid.jap.core.cache.JapCache;
import com.fujieid.jap.core.config.JapConfig;
import com.fujieid.jap.core.context.JapContext;
import com.fujieid.jap.core.result.JapErrorCode;
import com.fujieid.jap.core.result.JapResponse;
import com.fujieid.jap.core.store.JapUserStore;
import com.fujieid.jap.core.util.JapTokenHelper;
import com.fujieid.jap.core.util.RequestUtil;
import com.xkcoding.json.util.Kv;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JapAuthentication
implements Serializable {
    private static JapContext context;

    private JapAuthentication() {
    }

    public static JapContext getContext() {
        return context;
    }

    public static void setContext(JapContext japContext) {
        context = japContext;
    }

    public static JapUser getUser(HttpServletRequest request, HttpServletResponse response) {
        if (null == context) {
            return null;
        }
        JapUserStore japUserStore = context.getUserStore();
        if (null == japUserStore) {
            return null;
        }
        return japUserStore.get(request, response);
    }

    public static JapResponse checkUser(HttpServletRequest request, HttpServletResponse response) {
        JapUser japUser = JapAuthentication.getUser(request, response);
        if (null == japUser) {
            return JapResponse.error(JapErrorCode.NOT_LOGGED_IN);
        }
        return JapResponse.success(japUser);
    }

    public static Map<String, Object> checkToken(String token) {
        if (null == context || ObjectUtil.isEmpty((Object)token)) {
            return null;
        }
        JapCache japCache = context.getCache();
        if (null == japCache) {
            return null;
        }
        Map<String, Object> tokenMap = JapTokenHelper.checkToken(token);
        if (MapUtil.isNotEmpty(tokenMap)) {
            Kv kv = new Kv();
            kv.putAll(tokenMap);
            long iat = kv.getLong((Object)"iat") * 1000L;
            JapConfig japConfig = context.getConfig();
            long tokenExpireTime = japConfig.getTokenExpireTime();
            if (new Date(iat + tokenExpireTime).after(new Date())) {
                return tokenMap;
            }
        }
        return null;
    }

    public static boolean logout(HttpServletRequest request, HttpServletResponse response) {
        JapUserStore japUserStore = context.getUserStore();
        if (null == japUserStore) {
            return false;
        }
        japUserStore.remove(request, response);
        Map<String, Cookie> cookieMap = RequestUtil.getCookieMap(request);
        if (CollectionUtil.isNotEmpty(cookieMap)) {
            cookieMap.forEach((key, cookie) -> {
                cookie.setMaxAge(0);
                response.addCookie(cookie);
            });
        }
        return true;
    }
}

