/*
 * Decompiled with CFR 0.152.
 */
package com.fujieid.jap.core.result;

import cn.hutool.core.util.ObjectUtil;
import com.fujieid.jap.core.result.JapErrorCode;
import java.io.Serializable;

public class JapResponse
implements Serializable {
    private int code;
    private String message;
    private Object data;

    public static JapResponse success() {
        return new JapResponse().setCode(JapErrorCode.SUCCESS.getErrroCode()).setMessage(JapErrorCode.SUCCESS.getErrorMessage());
    }

    public static JapResponse success(Object data) {
        return new JapResponse().setCode(200).setData(data);
    }

    public static JapResponse error(JapErrorCode errorCode) {
        return new JapResponse().setCode(errorCode.getErrroCode()).setMessage(errorCode.getErrorMessage());
    }

    public static JapResponse error(int errorCode, String errorMessage) {
        return new JapResponse().setCode(errorCode).setMessage(errorMessage);
    }

    public boolean isSuccess() {
        return this.getCode() == 200;
    }

    public boolean isRedirectUrl() {
        Object data = this.getData();
        return this.isSuccess() && ObjectUtil.isNotNull((Object)data) && data instanceof String && ((String)data).startsWith("http");
    }

    public int getCode() {
        return this.code;
    }

    public JapResponse setCode(int code) {
        this.code = code;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public JapResponse setMessage(String message) {
        this.message = message;
        return this;
    }

    public Object getData() {
        return this.data;
    }

    public JapResponse setData(Object data) {
        this.data = data;
        return this;
    }
}

