/*
 * Decompiled with CFR 0.152.
 */
package com.fujieid.jap.core.store;

import cn.hutool.core.bean.BeanUtil;
import com.fujieid.jap.core.JapUser;
import com.fujieid.jap.core.config.JapConfig;
import com.fujieid.jap.core.context.JapAuthentication;
import com.fujieid.jap.core.store.JapUserStore;
import com.fujieid.jap.core.util.JapTokenHelper;
import com.fujieid.jap.core.util.JapUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class SessionJapUserStore
implements JapUserStore {
    @Override
    public JapUser save(HttpServletRequest request, HttpServletResponse response, JapUser japUser) {
        HttpSession session = request.getSession();
        JapUser newUser = (JapUser)BeanUtil.copyProperties((Object)japUser, JapUser.class, (String[])new String[0]);
        newUser.setPassword(null);
        session.setAttribute("_jap:session:user", (Object)newUser);
        JapConfig japConfig = JapAuthentication.getContext().getConfig();
        if (!japConfig.isSso()) {
            String token = JapUtil.createToken(japUser, request);
            JapTokenHelper.saveUserToken(japUser.getUserId(), token);
            japUser.setToken(token);
        }
        return japUser;
    }

    @Override
    public void remove(HttpServletRequest request, HttpServletResponse response) {
        JapUser japUser;
        JapConfig japConfig = JapAuthentication.getContext().getConfig();
        if (!japConfig.isSso() && null != (japUser = this.get(request, response))) {
            JapTokenHelper.removeUserToken(japUser.getUserId());
        }
        HttpSession session = request.getSession();
        session.removeAttribute("_jap:session:user");
        session.invalidate();
    }

    @Override
    public JapUser get(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession();
        return (JapUser)session.getAttribute("_jap:session:user");
    }
}

