/*
 * Decompiled with CFR 0.152.
 */
package com.fujieid.jap.core.store;

import cn.hutool.core.util.StrUtil;
import com.fujieid.jap.core.JapUser;
import com.fujieid.jap.core.JapUserService;
import com.fujieid.jap.core.store.SessionJapUserStore;
import com.fujieid.jap.core.util.JapTokenHelper;
import com.fujieid.jap.sso.JapSsoHelper;
import com.fujieid.jap.sso.config.JapSsoConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SsoJapUserStore
extends SessionJapUserStore {
    protected JapUserService japUserService;
    protected JapSsoConfig japSsoConfig;

    public SsoJapUserStore(JapUserService japUserService, JapSsoConfig japSsoConfig) {
        this.japUserService = japUserService;
        this.japSsoConfig = japSsoConfig;
    }

    @Override
    public JapUser save(HttpServletRequest request, HttpServletResponse response, JapUser japUser) {
        String token = JapSsoHelper.login((Object)japUser.getUserId(), (String)japUser.getUsername(), (JapSsoConfig)this.japSsoConfig, (HttpServletRequest)request, (HttpServletResponse)response);
        super.save(request, response, japUser);
        JapTokenHelper.saveUserToken(japUser.getUserId(), token);
        return japUser.setToken(token);
    }

    @Override
    public void remove(HttpServletRequest request, HttpServletResponse response) {
        JapUser japUser = this.get(request, response);
        if (null != japUser) {
            JapTokenHelper.removeUserToken(japUser.getUserId());
        }
        super.remove(request, response);
        JapSsoHelper.logout((HttpServletRequest)request, (HttpServletResponse)response);
    }

    @Override
    public JapUser get(HttpServletRequest request, HttpServletResponse response) {
        String userId = JapSsoHelper.checkLogin((HttpServletRequest)request);
        if (StrUtil.isBlank((CharSequence)userId)) {
            super.remove(request, response);
            return null;
        }
        JapUser sessionUser = super.get(request, response);
        if (null == sessionUser || !sessionUser.getUserId().equals(userId)) {
            sessionUser = this.japUserService.getById(userId);
            if (null == sessionUser) {
                return null;
            }
            super.save(request, response, sessionUser);
            return sessionUser;
        }
        return sessionUser;
    }
}

