/*
 * Decompiled with CFR 0.152.
 */
package com.fujieid.jap.core.strategy;

import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ObjectUtil;
import com.fujieid.jap.core.JapUser;
import com.fujieid.jap.core.JapUserService;
import com.fujieid.jap.core.cache.JapCache;
import com.fujieid.jap.core.cache.JapCacheConfig;
import com.fujieid.jap.core.cache.JapLocalCache;
import com.fujieid.jap.core.config.AuthenticateConfig;
import com.fujieid.jap.core.config.JapConfig;
import com.fujieid.jap.core.context.JapAuthentication;
import com.fujieid.jap.core.context.JapContext;
import com.fujieid.jap.core.exception.JapException;
import com.fujieid.jap.core.result.JapErrorCode;
import com.fujieid.jap.core.result.JapResponse;
import com.fujieid.jap.core.store.JapUserStore;
import com.fujieid.jap.core.store.SessionJapUserStore;
import com.fujieid.jap.core.store.SsoJapUserStore;
import com.fujieid.jap.core.strategy.JapStrategy;
import com.fujieid.jap.sso.JapSsoHelper;
import com.fujieid.jap.sso.config.JapSsoConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractJapStrategy
implements JapStrategy {
    protected JapUserService japUserService;
    protected JapContext japContext;

    public AbstractJapStrategy(JapUserService japUserService, JapConfig japConfig) {
        this(japUserService, japConfig, new JapLocalCache());
    }

    public AbstractJapStrategy(JapUserService japUserService, JapConfig japConfig, JapCache japCache) {
        this(japUserService, japConfig, japConfig.isSso() ? new SsoJapUserStore(japUserService, japConfig.getSsoConfig()) : new SessionJapUserStore(), japCache);
    }

    public AbstractJapStrategy(JapUserService japUserService, JapConfig japConfig, JapUserStore japUserStore, JapCache japCache) {
        this.japUserService = japUserService;
        if (japConfig.isSso()) {
            JapSsoHelper.initKissoConfig((JapSsoConfig)japConfig.getSsoConfig());
        }
        this.japContext = new JapContext(japUserStore, japCache, japConfig);
        JapAuthentication.setContext(this.japContext);
        JapCacheConfig.timeout = japConfig.getCacheExpireTime();
    }

    protected JapUser checkSession(HttpServletRequest request, HttpServletResponse response) {
        return this.japContext.getUserStore().get(request, response);
    }

    protected JapResponse loginSuccess(JapUser japUser, HttpServletRequest request, HttpServletResponse response) {
        this.japContext.getUserStore().save(request, response, japUser);
        return JapResponse.success(japUser);
    }

    protected void checkAuthenticateConfig(AuthenticateConfig sourceConfig, Class<?> targetConfigClazz) throws JapException {
        if (ObjectUtil.isNull((Object)sourceConfig)) {
            throw new JapException(JapErrorCode.MISS_AUTHENTICATE_CONFIG);
        }
        if (!ClassUtil.isAssignable(sourceConfig.getClass(), targetConfigClazz)) {
            throw new JapException("Unsupported parameter type, please use " + ClassUtil.getClassName(targetConfigClazz, (boolean)true) + ", a subclass of AuthenticateConfig");
        }
    }
}

