/*
 * Decompiled with CFR 0.152.
 */
package com.fujieid.jap.core.util;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.kisso.security.token.SSOToken;
import com.fujieid.jap.core.context.JapAuthentication;
import com.fujieid.jap.core.exception.JapException;
import com.fujieid.jap.sso.JapSsoUtil;
import com.xkcoding.json.util.StringUtil;
import java.io.Serializable;
import java.util.Map;

public class JapTokenHelper {
    public static void saveUserToken(String userId, String token) {
        if (StringUtil.isEmpty((String)userId)) {
            throw new JapException("Failed to save user token, userid cannot be empty.");
        }
        if (StringUtil.isEmpty((String)token)) {
            throw new JapException("Failed to save user token, user token cannot be empty.");
        }
        JapAuthentication.getContext().getCache().set("_jap:user:token:".concat(userId), (Serializable)((Object)token));
    }

    public static String getUserToken(String userId) {
        if (StringUtil.isEmpty((String)userId)) {
            throw new JapException("Failed to get user token, userid cannot be empty.");
        }
        return (String)((Object)JapAuthentication.getContext().getCache().get("_jap:user:token:".concat(userId)));
    }

    public static void removeUserToken(String userId) {
        if (StringUtil.isEmpty((String)userId)) {
            throw new JapException("Failed to remove user token, userid cannot be empty.");
        }
        JapAuthentication.getContext().getCache().removeKey("_jap:user:token:".concat(userId));
    }

    public static Map<String, Object> checkToken(String token) {
        SSOToken ssoToken = JapSsoUtil.parseToken((String)token);
        if (ObjectUtil.isNull((Object)ssoToken)) {
            return null;
        }
        String cacheKey = "_jap:user:token:".concat(ssoToken.getId());
        if (!JapAuthentication.getContext().getCache().containsKey(cacheKey)) {
            return null;
        }
        return ssoToken.getClaims();
    }
}

