/*
 * Decompiled with CFR 0.152.
 */
package com.fujieid.jap.core.util;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ArrayUtil;
import com.xkcoding.json.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RequestUtil {
    public static String getParam(String paramName, HttpServletRequest request) {
        if (null == request) {
            return null;
        }
        return request.getParameter(paramName);
    }

    public static String getHeader(String headerName, HttpServletRequest request) {
        if (null == request) {
            return "";
        }
        return request.getHeader(headerName);
    }

    public static String getReferer(HttpServletRequest request) {
        return RequestUtil.getHeader("Referer", request);
    }

    public static String getFullDomainName(HttpServletRequest request) {
        StringBuffer url = request.getRequestURL();
        return url.delete(url.length() - request.getRequestURI().length(), url.length()).toString();
    }

    public static String getUa(HttpServletRequest request) {
        return RequestUtil.getHeader("User-Agent", request);
    }

    public static String getIp(HttpServletRequest request) {
        String ip;
        String[] headers;
        if (null == request) {
            return "";
        }
        for (String header : headers = new String[]{"X-Forwarded-For", "X-Real-IP", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"}) {
            ip = request.getHeader(header);
            if (!RequestUtil.isValidIp(ip)) continue;
            return RequestUtil.getMultistageReverseProxyIp(ip);
        }
        ip = request.getRemoteAddr();
        return RequestUtil.getMultistageReverseProxyIp(ip);
    }

    private static String getMultistageReverseProxyIp(String ip) {
        if (ip != null && ip.indexOf(",") > 0) {
            String[] ips;
            for (String subIp : ips = ip.trim().split(",")) {
                if (!RequestUtil.isValidIp(subIp)) continue;
                ip = subIp;
                break;
            }
        }
        return ip;
    }

    private static boolean isValidIp(String ip) {
        return !StringUtil.isEmpty((String)ip) && !"unknown".equalsIgnoreCase(ip);
    }

    public static String getRequestUrl(boolean encode, HttpServletRequest request) {
        if (null == request) {
            return "";
        }
        String currentUrl = request.getRequestURL().toString();
        String queryString = request.getQueryString();
        if (!StringUtil.isEmpty((String)queryString)) {
            currentUrl = currentUrl + "?" + queryString;
        }
        if (encode) {
            String result = "";
            try {
                result = URLEncoder.encode(currentUrl, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            return result;
        }
        return currentUrl;
    }

    public static String getCookieVal(HttpServletRequest request, String name) {
        Cookie cookie = RequestUtil.getCookie(request, name);
        return cookie != null ? cookie.getValue() : null;
    }

    public static Cookie getCookie(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!name.equals(cookie.getName())) continue;
                return cookie;
            }
        }
        return null;
    }

    public static Map<String, Cookie> getCookieMap(HttpServletRequest request) {
        Object[] cookies = request.getCookies();
        if (ArrayUtil.isEmpty((Object[])cookies)) {
            return MapUtil.empty();
        }
        return Arrays.stream(cookies).collect(Collectors.toMap(Cookie::getName, v -> v, (k1, k2) -> k1));
    }

    public static void setCookie(HttpServletResponse response, String name, String value, int maxAge, String path, String domain) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath(path);
        if (null != domain) {
            cookie.setDomain(domain);
        }
        cookie.setMaxAge(maxAge);
        cookie.setHttpOnly(false);
        response.addCookie(cookie);
    }
}

