/*
 * Decompiled with CFR 0.152.
 */
package com.fujieid.jap.sso;

import com.baomidou.kisso.SSOConfig;
import com.baomidou.kisso.SSOHelper;
import com.baomidou.kisso.security.token.SSOToken;
import com.baomidou.kisso.service.ConfigurableAbstractKissoService;
import com.fujieid.jap.sso.JapSsoUtil;
import com.fujieid.jap.sso.config.JapSsoConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JapSsoHelper {
    public static String login(Object userId, String username, JapSsoConfig japSsoConfig, HttpServletRequest request, HttpServletResponse response) {
        japSsoConfig = null == japSsoConfig ? new JapSsoConfig() : japSsoConfig;
        JapSsoHelper.resetKissoConfig(japSsoConfig);
        SSOToken ssoToken = JapSsoUtil.createSsoToken(userId, username, request);
        KiSsoHelper.setCookie((HttpServletRequest)request, (HttpServletResponse)response, (SSOToken)ssoToken, (boolean)true);
        return ssoToken.getToken();
    }

    public static void initKissoConfig(JapSsoConfig japSsoConfig) {
        SSOConfig ssoConfig = JapSsoHelper.resetKissoConfig(japSsoConfig);
        KiSsoHelper.setKissoService(new JapConfigurableAbstractKissoService(ssoConfig));
    }

    private static SSOConfig resetKissoConfig(JapSsoConfig japSsoConfig) {
        SSOConfig ssoConfig = KiSsoHelper.getSsoConfig();
        ssoConfig.setCookieDomain(japSsoConfig.getCookieDomain());
        ssoConfig.setCookieName(japSsoConfig.getCookieName());
        ssoConfig.setParamReturnUrl(japSsoConfig.getParamReturnUrl());
        ssoConfig.setCookieMaxAge(japSsoConfig.getCookieMaxAge());
        KiSsoHelper.setSsoConfig((SSOConfig)ssoConfig);
        return ssoConfig;
    }

    public static String checkLogin(HttpServletRequest request) {
        SSOToken ssoToken = KiSsoHelper.getSSOToken((HttpServletRequest)request);
        return null == ssoToken ? null : ssoToken.getId();
    }

    public static void logout(HttpServletRequest request, HttpServletResponse response) {
        KiSsoHelper.clearLogin((HttpServletRequest)request, (HttpServletResponse)response);
    }

    static class KiSsoHelper
    extends SSOHelper {
        KiSsoHelper() {
        }

        public static void setKissoService(JapConfigurableAbstractKissoService japKissoService) {
            kissoService = japKissoService;
        }
    }

    static class JapConfigurableAbstractKissoService
    extends ConfigurableAbstractKissoService {
        public JapConfigurableAbstractKissoService(SSOConfig ssoConfig) {
            this.config = ssoConfig;
        }
    }
}

