/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataset.controller;

import com.gccloud.common.permission.ApiPermission;
import com.gccloud.common.vo.PageVO;
import com.gccloud.common.vo.R;
import com.gccloud.dataset.dto.LabelDTO;
import com.gccloud.dataset.dto.LabelSearchDTO;
import com.gccloud.dataset.entity.LabelEntity;
import com.gccloud.dataset.service.IDatasetLabelService;
import com.gccloud.dataset.service.ILabelService;
import com.gccloud.dataset.vo.DatasetLabelVO;
import com.gccloud.dataset.vo.LabelVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6807\u7b7e\u914d\u7f6e"})
@RestController
@RequestMapping(value={"/label"})
public class LabelController {
    @Resource
    private ILabelService labelService;
    @Resource
    private IDatasetLabelService datasetLabelService;

    @ApiOperation(value="\u67e5\u8be2\u6807\u7b7e")
    @GetMapping(value={"/list"})
    @ApiPermission(permissions={"dataset:label"})
    public R<PageVO<LabelEntity>> getPage(@ApiParam(name="\u67e5\u8be2", value="\u4f20\u5165\u67e5\u8be2\u6761\u4ef6", required=true) LabelSearchDTO searchDTO) {
        PageVO<LabelEntity> page = this.labelService.getPage(searchDTO);
        return R.success(page);
    }

    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539\u6807\u7b7e")
    @PostMapping(value={"/addOrUpdateLabel"})
    @ApiPermission(permissions={"dataset:label:edit"})
    public R<Void> addOrUpdateLabel(@RequestBody LabelDTO labelDTO) {
        if (StringUtils.isNotBlank((CharSequence)labelDTO.getId())) {
            this.labelService.update(labelDTO);
            return R.success();
        }
        this.labelService.add(labelDTO);
        return R.success();
    }

    @ApiOperation(value="\u68c0\u67e5\u6807\u7b7e\u662f\u5426\u91cd\u590d")
    @PostMapping(value={"/checkRepeat"})
    @ApiPermission(permissions={"dataset:label"})
    public R<Boolean> checkRepeat(@RequestBody LabelEntity labelEntity) {
        boolean repeat = this.labelService.checkRepeat(labelEntity);
        return R.success((Object)repeat);
    }

    @ApiOperation(value="\u5220\u9664\u6807\u7b7e")
    @GetMapping(value={"/removeLabel/{id}"})
    @ApiPermission(permissions={"dataset:label:edit"})
    public R<Void> removeLabel(@PathVariable String id) {
        this.labelService.delete(id);
        return R.success();
    }

    @ApiOperation(value="\u83b7\u53d6\u6807\u7b7e\u8be6\u60c5")
    @GetMapping(value={"/getLabelDetail/{id}"})
    @ApiPermission(permissions={"dataset:label"})
    public R<LabelVO> getLabelDetail(@PathVariable String id) {
        LabelVO labelVO = this.labelService.getInfoById(id);
        return R.success((Object)((Object)labelVO));
    }

    @ApiOperation(value="\u83b7\u53d6\u5168\u90e8\u6807\u7b7e\u4fe1\u606f")
    @GetMapping(value={"/getLabelList"})
    @ApiPermission(permissions={"dataset:label"})
    public R<List<LabelEntity>> getLabelList() {
        List list = this.labelService.list();
        return R.success((Object)list);
    }

    @ApiOperation(value="\u83b7\u53d6\u6807\u7b7e\u7c7b\u578b")
    @GetMapping(value={"/getLabelType"})
    @ApiPermission(permissions={"dataset:label"})
    public R<List<String>> getLabelType() {
        List<String> labelType = this.labelService.getLabelType();
        return R.success(labelType);
    }

    @ApiOperation(value="\u901a\u8fc7\u6807\u7b7e\u7c7b\u578b\u5220\u9664\u6807\u7b7e")
    @PostMapping(value={"/removeLabelByType"})
    @ApiPermission(permissions={"dataset:label:edit"})
    public R<Void> removeLabelByType(@RequestBody LabelDTO labelVO) {
        this.labelService.deleteLabelByType(labelVO.getLabelType());
        return R.success();
    }

    @ApiOperation(value="\u6807\u7b7e\u7c7b\u578b\u7684\u4fee\u6539")
    @PostMapping(value={"/updateLabelType"})
    @ApiPermission(permissions={"dataset:label:edit"})
    public R<Void> updateLabelType(@RequestBody LabelDTO labelVO) {
        this.labelService.updateLabelType(labelVO.getLabelType(), labelVO.getOldLabelType());
        return R.success();
    }

    @ApiOperation(value="\u901a\u8fc7\u6570\u636e\u96c6id\u83b7\u53d6\u6807\u7b7e")
    @GetMapping(value={"/queryDataSetLabelList/{dataSetId}"})
    @ApiPermission(permissions={"dataset:label"})
    public R<List<LabelEntity>> queryDataSetLabelList(@PathVariable String dataSetId) {
        List<LabelEntity> labelList = this.datasetLabelService.getLabelByDatasetId(dataSetId);
        return R.success(labelList);
    }

    @ApiOperation(value="\u901a\u8fc7\u6807\u7b7eid\u83b7\u53d6\u5173\u8054\u7684\u6570\u636e\u96c6id")
    @GetMapping(value={"/queryDataSetIdList/{labelId}"})
    @ApiPermission(permissions={"dataset:label"})
    public R<List<String>> queryDataSetIdList(@PathVariable String labelId) {
        List<DatasetLabelVO> datasetLabelVOList = this.datasetLabelService.getDatasetByLabelId(labelId);
        List dataSetIdList = datasetLabelVOList.stream().map(DatasetLabelVO::getId).collect(Collectors.toList());
        return R.success(dataSetIdList);
    }

    @ApiOperation(value="\u901a\u8fc7\u6570\u636e\u96c6id\u548c\u6807\u7b7eid\u89e3\u9664\u6807\u7b7e")
    @GetMapping(value={"/removeDataSetLabel"})
    @ApiPermission(permissions={"dataset:label:edit"})
    public R<Void> removeDataSetLabel(String dataSetId, String labelId) {
        this.datasetLabelService.delete(dataSetId, labelId);
        return R.success();
    }
}

