/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataset.service.impl.dataset;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gccloud.common.exception.GlobalException;
import com.gccloud.common.utils.JSON;
import com.gccloud.common.vo.PageVO;
import com.gccloud.dataset.constant.DatasetConstant;
import com.gccloud.dataset.dao.DatasetDao;
import com.gccloud.dataset.dto.DatasetParamDTO;
import com.gccloud.dataset.dto.TestExecuteDTO;
import com.gccloud.dataset.entity.DatasetEntity;
import com.gccloud.dataset.entity.DatasourceEntity;
import com.gccloud.dataset.entity.config.CustomDataSetConfig;
import com.gccloud.dataset.extend.dataset.DatasetExtendClient;
import com.gccloud.dataset.params.ParamsClient;
import com.gccloud.dataset.permission.DatasetPermissionClient;
import com.gccloud.dataset.service.IBaseDataSetService;
import com.gccloud.dataset.service.IBaseDatasourceService;
import com.gccloud.dataset.service.factory.DatasourceServiceFactory;
import com.gccloud.dataset.service.impl.datasource.BaseDatasourceServiceImpl;
import com.gccloud.dataset.utils.DBUtils;
import com.gccloud.dataset.utils.MybatisParameterUtils;
import com.gccloud.dataset.vo.DataVO;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="custom")
public class CustomDataSetServiceImpl
extends ServiceImpl<DatasetDao, DatasetEntity>
implements IBaseDataSetService {
    private static final Logger log = LoggerFactory.getLogger(CustomDataSetServiceImpl.class);
    @Resource
    private DatasourceServiceFactory datasourceServiceFactory;
    @Resource
    private BaseDatasourceServiceImpl datasourceService;
    @Resource
    private ParamsClient paramsClient;
    @Resource
    private DatasetPermissionClient datasetPermissionClient;
    @Resource
    private DatasetExtendClient datasetExtendClient;
    @Resource
    private MybatisParameterUtils parameterUtils;

    @Override
    public String add(DatasetEntity entity) {
        String id = IBaseDataSetService.super.add(entity);
        if (this.datasetPermissionClient.hasPermissionService()) {
            this.datasetPermissionClient.addPermission(id);
        }
        return id;
    }

    @Override
    public void delete(String id) {
        IBaseDataSetService.super.delete(id);
        if (this.datasetPermissionClient.hasPermissionService()) {
            this.datasetPermissionClient.deletePermission(id);
        }
    }

    public PageVO execute(String id, List<DatasetParamDTO> params, int current, int size) {
        long startTime = System.currentTimeMillis();
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new GlobalException("\u6570\u636e\u96c6id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DatasetEntity entity = this.getByIdFromCache(id);
        if (entity == null) {
            throw new GlobalException("\u6570\u636e\u96c6\u4e0d\u5b58\u5728");
        }
        CustomDataSetConfig config = (CustomDataSetConfig)entity.getConfig();
        String sql = config.getSqlProcess();
        sql = this.paramsClient.handleScript(entity.getDatasetType(), sql);
        params = this.paramsClient.handleParams(params);
        sql = "mybatis".equals(config.getSyntaxType()) ? this.parameterUtils.updateParamsConfig(sql, params) : DBUtils.updateParamsConfig(sql, params);
        String dataSourceId = entity.getSourceId();
        DatasourceEntity datasource = this.datasourceService.getInfoById(dataSourceId);
        IBaseDatasourceService buildService = this.datasourceServiceFactory.build(datasource.getSourceType());
        log.info("\u6267\u884c\u3010{}\u3011\u6570\u636e\u96c6\uff08\u7c7b\u578b\uff1a\u3010\u81ea\u52a9\u3011\uff0cID:\u3010{}\u3011\uff09\uff0c \u53c2\u6570\uff1a\u3010{}\u3011\uff0c URL\uff1a\u3010{}\u3011\uff0c \u6267\u884cSQL\uff1a\u3010{}\u3011", new Object[]{entity.getName(), entity.getId(), JSON.toJSONString(params), datasource.getUrl(), sql});
        DataVO dataVO = buildService.executeSqlPage(datasource, sql, current, size);
        PageVO data = (PageVO)dataVO.getData();
        List<Map<String, Object>> list = data.getList();
        list = this.datasetExtendClient.handleData(list, entity);
        data.setList(list);
        long endTime = System.currentTimeMillis();
        log.info("\u6267\u884c\u3010{}\u3011\u6570\u636e\u96c6\uff08\u7c7b\u578b\uff1a\u3010\u81ea\u52a9\u3011\uff0cID:\u3010{}\u3011\uff09\u7ed3\u675f\uff0c\u8017\u65f6\uff1a\u3010{}\u3011\u6beb\u79d2", new Object[]{entity.getName(), entity.getId(), endTime - startTime});
        return data;
    }

    @Override
    public Object execute(String id, List<DatasetParamDTO> params) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new GlobalException("\u6570\u636e\u96c6id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<DatasetParamDTO> finalParams = params;
        DatasetEntity entity = this.getByIdFromCache(id);
        if (entity == null) {
            throw new GlobalException("\u6570\u636e\u96c6\u4e0d\u5b58\u5728");
        }
        if (DatasetConstant.DatasetCache.OPEN.equals(entity.getCache())) {
            CompletableFuture future = DATASET_CACHE.get((Object)id, key -> this.getData(finalParams, entity));
            try {
                return future.get();
            }
            catch (Exception e) {
                log.error("\u6570\u636e\u96c6\u7f13\u5b58\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                log.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return this.getData(finalParams, entity);
    }

    private Object getData(List<DatasetParamDTO> finalParams, DatasetEntity entity) {
        long startTime = System.currentTimeMillis();
        CustomDataSetConfig config = (CustomDataSetConfig)entity.getConfig();
        String sql = config.getSqlProcess();
        String dataSourceId = entity.getSourceId();
        sql = this.paramsClient.handleScript(entity.getDatasetType(), sql);
        List<DatasetParamDTO> paramList = this.paramsClient.handleParams(finalParams);
        sql = "mybatis".equals(config.getSyntaxType()) ? this.parameterUtils.updateParamsConfig(sql, paramList) : DBUtils.updateParamsConfig(sql, paramList);
        DatasourceEntity datasource = this.datasourceService.getInfoById(dataSourceId);
        IBaseDatasourceService buildService = this.datasourceServiceFactory.build(datasource.getSourceType());
        log.info("\u6267\u884c\u3010{}\u3011\u6570\u636e\u96c6\uff08\u7c7b\u578b\uff1a\u3010\u81ea\u52a9\u3011\uff0cID:\u3010{}\u3011\uff09\uff0c \u53c2\u6570\uff1a\u3010{}\u3011\uff0c URL\uff1a\u3010{}\u3011\uff0c \u6267\u884cSQL\uff1a\u3010{}\u3011", new Object[]{entity.getName(), entity.getId(), JSON.toJSONString(finalParams), datasource.getUrl(), sql});
        DataVO dataVO = buildService.executeSql(datasource, sql);
        List<Map<String, Object>> list = (List<Map<String, Object>>)dataVO.getData();
        list = this.datasetExtendClient.handleData(list, entity);
        long endTime = System.currentTimeMillis();
        log.info("\u6267\u884c\u3010{}\u3011\u6570\u636e\u96c6\uff08\u7c7b\u578b\uff1a\u3010\u81ea\u52a9\u3011\uff0cID:\u3010{}\u3011\uff09\u7ed3\u675f\uff0c\u8017\u65f6\uff1a\u3010{}\u3011\u6beb\u79d2", new Object[]{entity.getName(), entity.getId(), endTime - startTime});
        return list;
    }

    @Override
    public DataVO execute(TestExecuteDTO executeDTO) {
        long startTime = System.currentTimeMillis();
        List<DatasetParamDTO> params = executeDTO.getParams();
        params = this.paramsClient.handleParams(params);
        String sql = executeDTO.getScript();
        sql = this.paramsClient.handleScript(executeDTO.getDataSetType(), sql);
        sql = "mybatis".equals(executeDTO.getSyntaxType()) ? this.parameterUtils.updateParamsConfig(sql, params) : DBUtils.updateParamsConfig(sql, params);
        DatasourceEntity datasource = this.datasourceService.getInfoById(executeDTO.getDataSourceId());
        IBaseDatasourceService buildService = this.datasourceServiceFactory.build(datasource.getSourceType());
        log.info("\u6d4b\u8bd5\u6570\u636e\u96c6\uff08\u7c7b\u578b\uff1a\u3010\u81ea\u52a9\u3011\uff09\uff0c \u53c2\u6570\uff1a\u3010{}\u3011\uff0c URL\uff1a\u3010{}\u3011\uff0c \u6267\u884cSQL\uff1a\u3010{}\u3011", new Object[]{JSON.toJSONString(params), datasource.getUrl(), sql});
        Integer current = executeDTO.getCurrent();
        Integer size = executeDTO.getSize();
        DataVO dataVO = size != null && current != null ? buildService.executeSqlPage(datasource, sql, current, size) : buildService.executeSql(datasource, sql);
        long endTime = System.currentTimeMillis();
        log.info("\u6d4b\u8bd5\u6570\u636e\u96c6\uff08\u7c7b\u578b\uff1a\u3010\u81ea\u52a9\u3011\uff09\u7ed3\u675f\uff0c\u8017\u65f6\uff1a\u3010{}\u3011\u6beb\u79d2", (Object)(endTime - startTime));
        executeDTO.setScript(sql);
        return dataVO;
    }
}

