/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataset.service.impl.datasource;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gccloud.common.exception.GlobalException;
import com.gccloud.dataset.dao.DatasourceDao;
import com.gccloud.dataset.dto.DatasourceDTO;
import com.gccloud.dataset.dto.ExcelHeaderDTO;
import com.gccloud.dataset.entity.DatasourceEntity;
import com.gccloud.dataset.service.IBaseDatasourceService;
import com.gccloud.dataset.vo.DataVO;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service(value="excel")
public class ExcelDatasourceServiceImpl
extends ServiceImpl<DatasourceDao, DatasourceEntity>
implements IBaseDatasourceService {
    @Resource
    private JdbcTemplate jdbcTemplate;
    private static final int BATCH_COUNT = 100;
    private List<Map<Integer, Object>> cachedDataList = new ArrayList<Map<Integer, Object>>(100);

    @Override
    public String add(DatasourceDTO datasourceDTO) {
        Map<String, Object> config = datasourceDTO.getConfig();
        String fileName = config.get("fileName").toString();
        String filePath = System.getProperty("java.io.tmpdir") + File.separator + "datasourceFile" + File.separator + fileName;
        File file = new File(filePath);
        if (!file.exists()) {
            throw new GlobalException("\u6587\u4ef6\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20");
        }
        final String tableName = "excel_" + RandomStringUtils.randomAlphabetic((int)5);
        datasourceDTO.setTableName(tableName);
        List headerList = (List)config.get("headerList");
        StringBuilder ddl = new StringBuilder("create table " + tableName + " (");
        ddl.append("`id` bigint(64) NOT NULL AUTO_INCREMENT COMMENT '\u4e3b\u952e',");
        for (ExcelHeaderDTO header : headerList) {
            String name = header.getColumnName();
            String type = header.getColumnType();
            ddl.append("`" + name + "` " + this.getDataType(type) + " DEFAULT NULL COMMENT '" + name + "',");
        }
        ddl.append("PRIMARY KEY (`id`)");
        ddl.append(") ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='excel\u6570\u636e\u6e90\u8868");
        ddl.append(datasourceDTO.getSourceName()).append("';");
        try {
            this.jdbcTemplate.execute(ddl.toString());
        }
        catch (Exception e) {
            throw new GlobalException("\u521b\u5efa\u8868\u5931\u8d25");
        }
        final Map headerMap = headerList.stream().collect(Collectors.toMap(ExcelHeaderDTO::getIndex, Function.identity()));
        Integer headRowNum = Integer.valueOf(config.get("headRowNum").toString());
        ((ExcelReaderBuilder)EasyExcel.read((File)file, (ReadListener)new AnalysisEventListener<Map<Integer, Object>>(){

            public void invoke(Map<Integer, Object> data, AnalysisContext context) {
                ExcelDatasourceServiceImpl.this.cachedDataList.add(data);
                if (ExcelDatasourceServiceImpl.this.cachedDataList.size() >= 100) {
                    this.saveData();
                    ExcelDatasourceServiceImpl.this.cachedDataList.clear();
                }
            }

            public void doAfterAllAnalysed(AnalysisContext context) {
            }

            private void saveData() {
                StringBuilder sql = new StringBuilder("insert into " + tableName + " (");
                List<String> columnList = headerMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> ((ExcelHeaderDTO)entry.getValue()).getColumnName()).collect(Collectors.toList());
                columnList.forEach(column -> sql.append((String)column).append(","));
                sql.deleteCharAt(sql.length() - 1);
                sql.append(") values ");
                for (Map data : ExcelDatasourceServiceImpl.this.cachedDataList) {
                    sql.append("(");
                    for (int i = 0; i < data.size(); ++i) {
                        ExcelHeaderDTO headerDTO = (ExcelHeaderDTO)headerMap.get(i);
                        String type = headerDTO.getColumnType();
                        String value = data.get(i).toString();
                        if ("number".equalsIgnoreCase(type)) {
                            sql.append(value).append(",");
                            continue;
                        }
                        sql.append("'").append(value).append("',");
                    }
                    sql.deleteCharAt(sql.length() - 1);
                    sql.append("),");
                }
                sql.deleteCharAt(sql.length() - 1);
                ExcelDatasourceServiceImpl.this.jdbcTemplate.execute(sql.toString());
            }
        }).headRowNumber(headRowNum)).sheet().doRead();
        return IBaseDatasourceService.super.add(datasourceDTO);
    }

    private String getDataType(String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            return "text";
        }
        switch (type.toLowerCase()) {
            case "string": {
                return "text";
            }
            case "number": {
                return "bigint(64)";
            }
            case "date": {
                return "date";
            }
            case "datetime": {
                return "datetime";
            }
        }
        return "text";
    }

    private Map<Integer, String> parseExcelDataType(String filePath, Integer headerNum) {
        File file = new File(filePath);
        if (!file.exists()) {
            throw new GlobalException("\u6587\u4ef6\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20");
        }
        ((ExcelReaderBuilder)EasyExcel.read((File)file, (ReadListener)new AnalysisEventListener<Map<Integer, Object>>(){

            public void invoke(Map<Integer, Object> data, AnalysisContext context) {
                Map cellMap = context.readRowHolder().getCellMap();
                cellMap.forEach((k, v) -> {
                    CellData cellData = (CellData)v;
                    System.out.println(cellData.getType());
                });
            }

            public void doAfterAllAnalysed(AnalysisContext context) {
            }
        }).headRowNumber(headerNum)).sheet().doRead();
        return null;
    }

    @Override
    public void update(DatasourceDTO entity) {
        IBaseDatasourceService.super.update(entity);
    }

    @Override
    public void delete(String id) {
        DatasourceEntity datasource = (DatasourceEntity)((Object)this.getById((Serializable)((Object)id)));
        IBaseDatasourceService.super.delete(id);
        String tableName = datasource.getTableName();
        try {
            this.jdbcTemplate.execute("drop table if exists " + tableName);
        }
        catch (Exception e) {
            throw new GlobalException("\u5220\u9664\u8868\u5931\u8d25");
        }
    }

    @Override
    public DataVO executeSql(DatasourceEntity datasource, String sql) {
        return null;
    }

    @Override
    public DataVO executeSqlPage(DatasourceEntity datasource, String sql, Integer current, Integer size) {
        return IBaseDatasourceService.super.executeSqlPage(datasource, sql, current, size);
    }
}

