/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataset.utils;

import com.gccloud.common.exception.GlobalException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DESUtils {
    private static final Logger log = LoggerFactory.getLogger(DESUtils.class);
    private static final String KEY_STR = "GC_REPORT";
    private static final String CHARSET = "UTF8";
    private static final Key key;

    public static String getEncryptString(String strMing) {
        String strMi;
        Base64.Encoder encoder = Base64.getEncoder();
        try {
            byte[] byteMing = strMing.getBytes(CHARSET);
            byte[] byteMi = DESUtils.encryptByte(byteMing);
            strMi = encoder.encodeToString(byteMi);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new GlobalException(e.getMessage());
        }
        finally {
            encoder = null;
            Object byteMing = null;
            Object byteMi = null;
        }
        return strMi;
    }

    public static String getDecryptString(String strMi) {
        String strMing;
        Base64.Decoder decoder = Base64.getDecoder();
        try {
            byte[] byteMi = decoder.decode(strMi);
            byte[] byteMing = DESUtils.decryptByte(byteMi);
            strMing = new String(byteMing, CHARSET);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new GlobalException(e.getMessage());
        }
        finally {
            decoder = null;
            Object byteMing = null;
            Object byteMi = null;
        }
        return strMing;
    }

    private static byte[] encryptByte(byte[] byteS) {
        byte[] byteFina;
        try {
            Cipher cipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
            cipher.init(1, key);
            byteFina = cipher.doFinal(byteS);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new GlobalException(e.getMessage());
        }
        finally {
            Object cipher = null;
        }
        return byteFina;
    }

    private static byte[] decryptByte(byte[] byteD) {
        byte[] byteFina = null;
        try {
            Cipher cipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
            cipher.init(2, key);
            byteFina = cipher.doFinal(byteD);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new GlobalException(e.getMessage());
        }
        finally {
            Object cipher = null;
        }
        return byteFina;
    }

    static {
        try {
            KeyGenerator _generator = KeyGenerator.getInstance("DES");
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            secureRandom.setSeed(KEY_STR.getBytes());
            _generator.init(56, secureRandom);
            key = _generator.generateKey();
            _generator = null;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new GlobalException(e.getMessage());
        }
    }
}

