/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.loader.classloader.resource.loader;

import com.gitee.starblues.loader.classloader.resource.loader.ResourceLoader;
import com.gitee.starblues.loader.classloader.resource.storage.ResourceStorage;
import com.gitee.starblues.loader.utils.IOUtils;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;

public abstract class AbstractResourceLoader
implements ResourceLoader {
    private static final String CLASS_FILE_EXTENSION = ".class";
    private boolean loaded = false;
    protected final URL baseUrl;

    protected AbstractResourceLoader(URL baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Override
    public URL getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    public final synchronized void load(ResourceStorage resourceStorage) throws Exception {
        if (this.loaded) {
            throw new Exception(this.getClass().getName() + ": \u5df2\u7ecf\u521d\u59cb\u5316\u4e86, \u4e0d\u80fd\u518d\u521d\u59cb\u5316!");
        }
        try {
            resourceStorage.add("/", this.baseUrl);
            this.loadOfChild(resourceStorage);
        }
        finally {
            this.loaded = true;
        }
    }

    protected abstract void loadOfChild(ResourceStorage var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getClassBytes(String path, InputStream inputStream, boolean isClose) throws Exception {
        if (!AbstractResourceLoader.isClass(path)) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            IOUtils.copy(inputStream, byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        finally {
            if (isClose) {
                IOUtils.closeQuietly(inputStream);
            }
            IOUtils.closeQuietly(byteArrayOutputStream);
        }
    }

    @Override
    public void close() throws Exception {
    }

    private static boolean isClass(String path) {
        if (path == null || "".equals(path)) {
            return false;
        }
        return path.toLowerCase().endsWith(CLASS_FILE_EXTENSION);
    }
}

