/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.loader.classloader.resource.loader;

import com.gitee.starblues.loader.classloader.resource.loader.AbstractResourceLoader;
import com.gitee.starblues.loader.classloader.resource.storage.ResourceStorage;
import java.io.File;
import java.io.FileInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Objects;

public class ClassPathLoader
extends AbstractResourceLoader {
    private final URL url;

    public ClassPathLoader(URL url) {
        super(url);
        this.url = Objects.requireNonNull(url, "url \u4e0d\u80fd\u4e3a\u7a7a");
    }

    public ClassPathLoader(File file) throws MalformedURLException {
        this(file.toPath());
    }

    public ClassPathLoader(Path path) throws MalformedURLException {
        super(path.toUri().toURL());
        this.url = this.baseUrl;
    }

    @Override
    protected void loadOfChild(ResourceStorage resourceStorage) throws Exception {
        File file = new File(this.url.toURI());
        this.load(resourceStorage, file, null);
    }

    private void load(ResourceStorage resourceStorage, File file, String currentPackageName) throws Exception {
        if (currentPackageName == null) {
            currentPackageName = "";
        } else {
            currentPackageName = "".equals(currentPackageName) ? file.getName() : currentPackageName + "/" + file.getName();
            this.loadResource(resourceStorage, file, currentPackageName);
        }
        if (file.isDirectory()) {
            File[] listFiles = file.listFiles();
            if (listFiles == null || listFiles.length == 0) {
                return;
            }
            for (File subFile : listFiles) {
                this.load(resourceStorage, subFile, currentPackageName);
            }
        }
    }

    private void loadResource(ResourceStorage resourceStorage, File file, String packageName) throws Exception {
        if (file.isDirectory()) {
            this.addResource(resourceStorage, file, packageName + "/");
        } else {
            this.addResource(resourceStorage, file, packageName);
        }
    }

    private void addResource(ResourceStorage resourceStorage, File file, String packageName) throws Exception {
        resourceStorage.add(packageName, new URL(this.url.toString() + packageName), () -> {
            if (file.exists() && file.isFile()) {
                return this.getClassBytes(file.getPath(), new FileInputStream(file), true);
            }
            return null;
        });
    }
}

