/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.loader.classloader.resource.loader;

import com.gitee.starblues.loader.classloader.resource.Resource;
import com.gitee.starblues.loader.classloader.resource.loader.AbstractResourceLoader;
import com.gitee.starblues.loader.classloader.resource.loader.ClassPathLoader;
import com.gitee.starblues.loader.classloader.resource.loader.JarResourceLoader;
import com.gitee.starblues.loader.classloader.resource.loader.ResourceLoader;
import com.gitee.starblues.loader.classloader.resource.loader.ResourceLoaderFactory;
import com.gitee.starblues.loader.classloader.resource.storage.ResourceStorage;
import com.gitee.starblues.loader.classloader.resource.storage.SameRootResourceStorage;
import com.gitee.starblues.loader.launcher.ResourceLoaderFactoryGetter;
import com.gitee.starblues.loader.utils.IOUtils;
import com.gitee.starblues.loader.utils.ResourceUtils;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultResourceLoaderFactory
implements ResourceLoaderFactory {
    private final Map<URL, SameRootResourceStorage> resourceLoaderMap = new ConcurrentHashMap<URL, SameRootResourceStorage>();
    private final String classLoaderName;

    public DefaultResourceLoaderFactory(String classLoaderName) {
        this.classLoaderName = classLoaderName;
    }

    @Override
    public void addResource(String path) throws Exception {
        if (path == null || "".equals(path)) {
            return;
        }
        this.addResource(Paths.get(path, new String[0]));
    }

    @Override
    public void addResource(File file) throws Exception {
        if (file == null) {
            return;
        }
        this.addResource(file.toPath());
    }

    @Override
    public void addResource(Path path) throws Exception {
        if (path == null) {
            return;
        }
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        this.addResource(path.toUri().toURL());
    }

    @Override
    public void addResource(URL url) throws Exception {
        AbstractResourceLoader resourceLoader = null;
        if (ResourceUtils.isJarFileUrl(url)) {
            resourceLoader = ResourceUtils.isJarProtocolUrl(url) ? new JarResourceLoader(url) : new JarResourceLoader(Paths.get(url.toURI()).toFile());
        } else if (ResourceUtils.isZipFileUrl(url)) {
            resourceLoader = new JarResourceLoader(Paths.get(url.toURI()).toFile());
        } else if (ResourceUtils.isFileUrl(url)) {
            resourceLoader = new ClassPathLoader(url);
        }
        if (resourceLoader != null) {
            this.addResource(resourceLoader);
        }
    }

    @Override
    public void addResource(ResourceLoader resourceLoader) throws Exception {
        if (resourceLoader == null) {
            return;
        }
        if (this.resourceLoaderMap.containsKey(resourceLoader.getBaseUrl())) {
            return;
        }
        SameRootResourceStorage resourceStorage = ResourceLoaderFactoryGetter.getResourceStorage(this.classLoaderName, resourceLoader.getBaseUrl());
        resourceLoader.load(resourceStorage);
        if (!resourceStorage.isEmpty()) {
            this.resourceLoaderMap.put(resourceLoader.getBaseUrl(), resourceStorage);
        }
    }

    @Override
    public Resource findResource(String name) {
        for (Map.Entry<URL, SameRootResourceStorage> entry : this.resourceLoaderMap.entrySet()) {
            ResourceStorage resourceStorage = entry.getValue();
            Resource resource = resourceStorage.get(name);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    @Override
    public Enumeration<Resource> findResources(final String name) {
        return new Enumeration<Resource>(){
            private final List<SameRootResourceStorage> list;
            private int index;
            private Resource resource;
            {
                this.list = new ArrayList(DefaultResourceLoaderFactory.this.resourceLoaderMap.values());
                this.index = 0;
                this.resource = null;
            }

            @Override
            public boolean hasMoreElements() {
                return this.next();
            }

            @Override
            public Resource nextElement() {
                if (!this.next()) {
                    throw new NoSuchElementException();
                }
                Resource r = this.resource;
                this.resource = null;
                return r;
            }

            private boolean next() {
                if (this.resource != null) {
                    return true;
                }
                while (this.index < this.list.size()) {
                    SameRootResourceStorage resourceStorage = this.list.get(this.index++);
                    this.resource = this.getResource(resourceStorage);
                    if (this.resource == null) continue;
                    return true;
                }
                return false;
            }

            private Resource getResource(SameRootResourceStorage resourceStorage) {
                this.resource = resourceStorage.get(name);
                if (this.resource != null) {
                    return this.resource;
                }
                return null;
            }
        };
    }

    @Override
    public InputStream getInputStream(String name) {
        for (Map.Entry<URL, SameRootResourceStorage> entry : this.resourceLoaderMap.entrySet()) {
            ResourceStorage resourceStorage = entry.getValue();
            InputStream inputStream = resourceStorage.getInputStream(name);
            if (inputStream == null) continue;
            return inputStream;
        }
        return null;
    }

    @Override
    public List<URL> getUrls() {
        return new ArrayList<URL>(this.resourceLoaderMap.keySet());
    }

    @Override
    public void close() throws Exception {
        for (ResourceStorage resourceStorage : this.resourceLoaderMap.values()) {
            IOUtils.closeQuietly(resourceStorage);
        }
        this.resourceLoaderMap.clear();
    }
}

