/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.loader.launcher;

import com.gitee.starblues.loader.archive.Archive;
import com.gitee.starblues.loader.archive.ExplodedArchive;
import com.gitee.starblues.loader.archive.JarFileArchive;
import com.gitee.starblues.loader.classloader.GenericClassLoader;
import com.gitee.starblues.loader.classloader.resource.loader.MainJarResourceLoader;
import com.gitee.starblues.loader.launcher.MainProgramLauncher;
import com.gitee.starblues.loader.launcher.runner.MethodRunner;
import com.gitee.starblues.loader.utils.FilesUtils;
import com.gitee.starblues.loader.utils.ObjectUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.jar.Manifest;

public class MainJarOuterProgramLauncher
extends MainProgramLauncher {
    private static final Archive.EntryFilter ENTRY_FILTER = entry -> {
        String name = entry.getName();
        return name.startsWith("classes/");
    };
    private static final Archive.EntryFilter INCLUDE_FILTER = entry -> {
        if (entry.isDirectory()) {
            return entry.getName().equals("classes/");
        }
        return false;
    };
    private final File rootJarFile;

    public MainJarOuterProgramLauncher(MethodRunner methodRunner, File rootJarFile) {
        super(methodRunner);
        this.rootJarFile = Objects.requireNonNull(rootJarFile, "\u53c2\u6570 rootJarFile \u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Override
    protected void addResource(GenericClassLoader classLoader) throws Exception {
        super.addResource(classLoader);
        Archive archive = this.getArchive();
        Iterator<Archive> archiveIterator = archive.getNestedArchives(ENTRY_FILTER, INCLUDE_FILTER);
        this.addEntryResource(archiveIterator, classLoader);
        this.addLibResource(archive, classLoader);
    }

    private Archive getArchive() throws IOException {
        return this.rootJarFile.isDirectory() ? new ExplodedArchive(this.rootJarFile) : new JarFileArchive(this.rootJarFile);
    }

    private void addEntryResource(Iterator<Archive> archives, GenericClassLoader classLoader) throws Exception {
        while (archives.hasNext()) {
            Archive archive = archives.next();
            URL url = archive.getUrl();
            String path = url.getPath();
            if (!path.contains("/classes!/")) continue;
            classLoader.addResource(new MainJarResourceLoader(url));
        }
    }

    private void addLibResource(Archive archive, GenericClassLoader classLoader) throws Exception {
        Manifest manifest = archive.getManifest();
        String libDir = manifest.getMainAttributes().getValue("Lib-Dir");
        String relativePath = this.rootJarFile.isDirectory() ? this.rootJarFile.getPath() : this.rootJarFile.getParent();
        libDir = FilesUtils.resolveRelativePath(relativePath, libDir);
        File libJarDir = new File(libDir);
        if (!libJarDir.exists()) {
            throw new IllegalStateException("\u4e3b\u7a0b\u5e8f\u4f9d\u8d56\u76ee\u5f55\u4e0d\u5b58\u5728: " + libDir);
        }
        List<String> libIndexes = this.getLibIndexes(manifest);
        this.addLibJarFile(libJarDir, libIndexes, classLoader);
    }

    private List<String> getLibIndexes(Manifest manifest) {
        String libIndexes = manifest.getMainAttributes().getValue("Lib-Indexes");
        if (ObjectUtils.isEmpty(libIndexes)) {
            return Collections.emptyList();
        }
        String[] indexSplit = libIndexes.split(" ");
        ArrayList<String> indexes = new ArrayList<String>(indexSplit.length);
        for (String index : indexSplit) {
            if (ObjectUtils.isEmpty(index)) continue;
            indexes.add(index);
        }
        if (indexes.isEmpty()) {
            throw new IllegalStateException("\u4e3b\u7a0b\u5e8f\u4f9d\u8d56\u5305\u672a\u53d1\u73b0!");
        }
        return indexes;
    }

    private void addLibJarFile(File rootFile, List<String> libIndexes, GenericClassLoader classLoader) throws Exception {
        final HashSet<String> linIndexes = new HashSet<String>(libIndexes);
        File[] listFiles = rootFile.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return linIndexes.contains(pathname.getName());
            }
        });
        if (listFiles == null || listFiles.length == 0) {
            return;
        }
        for (File listFile : listFiles) {
            classLoader.addResource(listFile);
        }
    }
}

