/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.loader.launcher;

import com.gitee.starblues.loader.classloader.resource.loader.DefaultResourceLoaderFactory;
import com.gitee.starblues.loader.classloader.resource.loader.ResourceLoaderFactory;
import com.gitee.starblues.loader.classloader.resource.storage.CacheResourceStorage;
import com.gitee.starblues.loader.classloader.resource.storage.DefaultResourceStorage;
import com.gitee.starblues.loader.classloader.resource.storage.SameRootResourceStorage;
import com.gitee.starblues.loader.classloader.resource.storage.ShareResourceStorage;
import java.net.URL;
import java.util.Objects;

public class ResourceLoaderFactoryGetter {
    private static final String PARAMS_KEY = "--resource.store.mode";
    private static final String RESOURCE_MODE_CACHE_ISOLATION = "cache-isolation";
    private static final String RESOURCE_MODE_CACHE_SHARE = "cache-share";
    private static final String RESOURCE_MODE_NO_CACHE = "no-cache";
    private static volatile String resourceMode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ResourceLoaderFactory get(String classLoaderName, String ... args) {
        if (resourceMode != null) return new DefaultResourceLoaderFactory(classLoaderName);
        Class<ResourceLoaderFactory> clazz = ResourceLoaderFactory.class;
        synchronized (ResourceLoaderFactory.class) {
            if (resourceMode != null) return new DefaultResourceLoaderFactory(classLoaderName);
            resourceMode = ResourceLoaderFactoryGetter.parseArg(args);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return new DefaultResourceLoaderFactory(classLoaderName);
        }
    }

    private static String parseArg(String ... args) {
        for (String arg : args) {
            if (!arg.startsWith(PARAMS_KEY)) continue;
            String[] split = arg.split("=");
            if (split.length != 2) {
                return null;
            }
            return split[1];
        }
        return null;
    }

    public static SameRootResourceStorage getResourceStorage(String key, URL baseUrl) {
        DefaultResourceStorage resourceStorage = null;
        resourceStorage = Objects.equals(resourceMode, RESOURCE_MODE_NO_CACHE) ? new DefaultResourceStorage(baseUrl) : (Objects.equals(resourceMode, RESOURCE_MODE_CACHE_SHARE) ? new ShareResourceStorage(key, baseUrl) : new CacheResourceStorage(baseUrl));
        return resourceStorage;
    }
}

