/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.loader.launcher;

import com.gitee.starblues.loader.jar.JarFile;
import com.gitee.starblues.loader.launcher.MainJarOuterProgramLauncher;
import com.gitee.starblues.loader.launcher.MainJarProgramLauncher;
import com.gitee.starblues.loader.launcher.MainProgramLauncher;
import com.gitee.starblues.loader.launcher.SpringMainBootstrap;
import com.gitee.starblues.loader.launcher.runner.MethodRunner;
import com.gitee.starblues.loader.utils.ObjectUtils;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class SpringMainProdBootstrap {
    public static void main(String[] args) throws Exception {
        JarFile.registerUrlProtocolHandler();
        new SpringMainProdBootstrap().run(args);
    }

    private void run(String[] args) throws Exception {
        String mainPackageType;
        File rootJarFile = this.getRootJarFile();
        String startClass = null;
        try (JarFile jarFile = new JarFile(rootJarFile);){
            Manifest manifest = jarFile.getManifest();
            IllegalStateException exception = new IllegalStateException("\u5f53\u524d\u542f\u52a8\u5305\u975e\u6cd5\u5305!");
            if (manifest == null || manifest.getMainAttributes() == null) {
                throw exception;
            }
            Attributes mainAttributes = manifest.getMainAttributes();
            startClass = mainAttributes.getValue("Start-Class");
            if (ObjectUtils.isEmpty(startClass)) {
                throw exception;
            }
            mainPackageType = mainAttributes.getValue("Main-Package-Type");
        }
        MethodRunner methodRunner = new MethodRunner(startClass, "run", args);
        MainProgramLauncher launcher = Objects.equals(mainPackageType, "jar-outer") ? new MainJarOuterProgramLauncher(methodRunner, rootJarFile) : new MainJarProgramLauncher(methodRunner, rootJarFile);
        launcher.run(args);
    }

    private File getRootJarFile() throws URISyntaxException {
        String path;
        ProtectionDomain protectionDomain = SpringMainBootstrap.class.getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        URI location = codeSource != null ? codeSource.getLocation().toURI() : null;
        String string = path = location != null ? location.getSchemeSpecificPart() : null;
        if (path == null) {
            throw new IllegalStateException("Unable to determine code source archive");
        }
        File root = new File(path);
        if (!root.exists()) {
            throw new IllegalStateException("Unable to determine code source archive from " + root);
        }
        return root;
    }
}

