/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.loader.launcher.runner;

import com.gitee.starblues.loader.utils.CompareClassTypeUtils;
import com.gitee.starblues.loader.utils.ObjectUtils;
import java.lang.reflect.Method;
import java.util.Objects;

public class MethodRunner {
    protected final String className;
    protected final String runMethodName;
    protected String[] args;

    public MethodRunner(String className, String runMethodName, String[] args) {
        this.className = this.checkEmpty(className, "className \u4e0d\u80fd\u4e3a\u7a7a");
        this.runMethodName = this.checkEmpty(runMethodName, "runMethod \u4e0d\u80fd\u4e3a\u7a7a");
        this.args = args != null ? (String[])args.clone() : null;
    }

    public Object run() throws Exception {
        return this.run(null);
    }

    public Object run(ClassLoader classLoader) throws Exception {
        Class<?> runClass = this.loadRunClass(classLoader);
        return this.runMethod(runClass);
    }

    protected Class<?> loadRunClass(ClassLoader classLoader) throws Exception {
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        return Class.forName(this.className, false, classLoader);
    }

    protected Object runMethod(Class<?> runClass) throws Exception {
        Method runMethod = this.findRunMethod(runClass);
        if (runMethod == null) {
            throw new NoSuchMethodException(runClass.getName() + "." + this.runMethodName + "(String[] args)");
        }
        Object instance = this.getInstance(runClass);
        runMethod.setAccessible(true);
        runMethod.invoke(instance, new Object[]{this.args});
        return instance;
    }

    protected Object getInstance(Class<?> runClass) throws Exception {
        return runClass.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private String checkEmpty(String value, String msg) {
        if (ObjectUtils.isEmpty(value)) {
            throw new IllegalArgumentException(msg);
        }
        return value;
    }

    private Method findRunMethod(Class<?> runClass) {
        Class[] argClasses = new Class[]{String[].class};
        for (Class<?> searchType = runClass; searchType != null; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.isInterface() ? searchType.getMethods() : searchType.getDeclaredMethods()) {
                if (!Objects.equals(method.getName(), this.runMethodName) || !this.hasSameParams(method, argClasses)) continue;
                return method;
            }
        }
        return null;
    }

    private boolean hasSameParams(Method method, Class<?>[] paramTypes) {
        if (paramTypes.length != method.getParameterCount()) {
            return false;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            Class<?> methodParamType = parameterTypes[i];
            Class<?> paramType = paramTypes[i];
            if (!CompareClassTypeUtils.compare(methodParamType, paramType)) continue;
            return true;
        }
        return false;
    }
}

