/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.loader.utils;

import com.gitee.starblues.loader.utils.ObjectUtils;
import java.io.File;
import java.io.IOException;

public class FilesUtils {
    public static File getExistFile(String pathStr) {
        File file = new File(pathStr);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    public static String joiningFilePath(String ... paths) {
        if (paths == null || paths.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int length = paths.length;
        for (int i = 0; i < length; ++i) {
            String path = paths[i];
            if (ObjectUtils.isEmpty(path)) continue;
            if (i > 0) {
                if (path.startsWith(File.separator) || path.startsWith("/") || path.startsWith("\\") || path.startsWith("//")) {
                    stringBuilder.append(path);
                    continue;
                }
                stringBuilder.append(File.separator).append(path);
                continue;
            }
            stringBuilder.append(path);
        }
        return stringBuilder.toString();
    }

    public static File createFile(String path) throws IOException {
        try {
            File file = new File(path);
            File parentFile = file.getParentFile();
            if (!parentFile.exists() && !parentFile.mkdirs()) {
                throw new IOException("Create " + parentFile + " dir error");
            }
            if (file.createNewFile()) {
                return file;
            }
            throw new IOException("Create " + path + " file error");
        }
        catch (Exception e) {
            throw new IOException("Create " + path + " file error");
        }
    }

    public static String resolveRelativePath(String rootPath, String relativePath) {
        if (ObjectUtils.isEmpty(relativePath)) {
            return relativePath;
        }
        if (FilesUtils.isRelativePath(relativePath)) {
            return FilesUtils.joiningFilePath(rootPath, relativePath.replaceFirst("~", ""));
        }
        return relativePath;
    }

    public static boolean isRelativePath(String path) {
        if (ObjectUtils.isEmpty(path)) {
            return false;
        }
        return path.startsWith("~");
    }
}

