/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.loader.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Consumer;

public class IOUtils {
    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int len;
        if (inputStream == null) {
            throw new IllegalArgumentException("\u53c2\u6570inputStream\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("\u53c2\u6570inputStream\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        byte[] arr = new byte[1024];
        while ((len = bufferedInputStream.read(arr)) != -1) {
            bufferedOutputStream.write(arr, 0, len);
        }
        bufferedOutputStream.flush();
    }

    public static byte[] read(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("\u53c2\u6570inputStream\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int n = 0;
        while (-1 != (n = inputStream.read(buffer))) {
            output.write(buffer, 0, n);
        }
        return output.toByteArray();
    }

    public static void closeQuietly(AutoCloseable closeable) {
        IOUtils.closeQuietly(closeable, null);
    }

    public static void closeQuietly(AutoCloseable closeable, Consumer<Exception> consumer) {
        block3: {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (Exception e) {
                    if (consumer == null) break block3;
                    consumer.accept(e);
                }
            }
        }
    }
}

