/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.http.jodd;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jodd.http.HttpConnectionProvider;
import jodd.http.HttpRequest;
import jodd.http.HttpResponse;
import jodd.http.ProxyInfo;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.util.fs.FileUtils;
import me.chanjar.weixin.common.util.http.MediaDownloadRequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import org.apache.commons.lang3.StringUtils;

public class JoddHttpMediaDownloadRequestExecutor
extends MediaDownloadRequestExecutor<HttpConnectionProvider, ProxyInfo> {
    public JoddHttpMediaDownloadRequestExecutor(RequestHttp requestHttp, File tmpDirFile) {
        super(requestHttp, tmpDirFile);
    }

    @Override
    public File execute(String uri, String queryParam) throws WxErrorException, IOException {
        if (queryParam != null) {
            if (uri.indexOf(63) == -1) {
                uri = uri + '?';
            }
            uri = uri + (uri.endsWith("?") ? queryParam : '&' + queryParam);
        }
        HttpRequest request = HttpRequest.get((String)uri);
        if (this.requestHttp.getRequestHttpProxy() != null) {
            ((HttpConnectionProvider)this.requestHttp.getRequestHttpClient()).useProxy((ProxyInfo)this.requestHttp.getRequestHttpProxy());
        }
        request.withConnectionProvider((HttpConnectionProvider)this.requestHttp.getRequestHttpClient());
        HttpResponse response = request.send();
        response.charset("UTF-8");
        String contentType = response.header("Content-Type");
        if (contentType != null && contentType.startsWith("application/json")) {
            throw new WxErrorException(WxError.fromJson(response.bodyText()));
        }
        String fileName = this.getFileName(response);
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return null;
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(response.bodyBytes());
        String[] nameAndExt = fileName.split("\\.");
        return FileUtils.createTmpFile(inputStream, nameAndExt[0], nameAndExt[1], this.tmpDirFile);
    }

    private String getFileName(HttpResponse response) throws WxErrorException {
        String content = response.header("Content-disposition");
        if (content == null || content.length() == 0) {
            throw new WxErrorException(WxError.newBuilder().setErrorMsg("\u65e0\u6cd5\u83b7\u53d6\u5230\u6587\u4ef6\u540d").build());
        }
        Pattern p = Pattern.compile(".*filename=\"(.*)\"");
        Matcher m = p.matcher(content);
        if (m.matches()) {
            return m.group(1);
        }
        throw new WxErrorException(WxError.newBuilder().setErrorMsg("\u65e0\u6cd5\u83b7\u53d6\u5230\u6587\u4ef6\u540d").build());
    }
}

