/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.redis;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import me.chanjar.weixin.common.redis.WxRedisOps;
import me.chanjar.weixin.common.util.locks.JedisDistributedLock;
import redis.clients.jedis.Jedis;
import redis.clients.util.Pool;

public class JedisWxRedisOps
implements WxRedisOps {
    private final Pool<Jedis> jedisPool;

    @Override
    public String getValue(String key) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            String string = jedis.get(key);
            return string;
        }
    }

    @Override
    public void setValue(String key, String value, int expire, TimeUnit timeUnit) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            if (expire <= 0) {
                jedis.set(key, value);
            } else {
                jedis.psetex(key, timeUnit.toMillis(expire), value);
            }
        }
    }

    @Override
    public Long getExpire(String key) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.ttl(key);
            return l;
        }
    }

    @Override
    public void expire(String key, int expire, TimeUnit timeUnit) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            jedis.pexpire(key, timeUnit.toMillis(expire));
        }
    }

    @Override
    public Lock getLock(String key) {
        return new JedisDistributedLock(this.jedisPool, key);
    }

    public JedisWxRedisOps(Pool<Jedis> jedisPool) {
        this.jedisPool = jedisPool;
    }
}

