/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Optional;
import me.chanjar.weixin.common.bean.menu.WxMenu;
import me.chanjar.weixin.common.bean.menu.WxMenuButton;
import me.chanjar.weixin.common.bean.menu.WxMenuRule;
import me.chanjar.weixin.common.util.json.GsonHelper;

public class WxMenuGsonAdapter
implements JsonSerializer<WxMenu>,
JsonDeserializer<WxMenu> {
    private static final String FIELD_BUTTON = "button";
    private static final String FIELD_MATCH_RULE = "matchrule";
    private static final String FIELD_SUB_BUTTON = "sub_button";
    private static final String FIELD_MENU = "menu";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_KEY = "key";
    private static final String FIELD_URL = "url";
    private static final String FIELD_MEDIA_ID = "media_id";
    private static final String FIELD_ARTICLE_ID = "article_id";
    private static final String FIELD_APP_ID = "appid";
    private static final String FIELD_PAGE_PATH = "pagepath";
    private static final String FIELD_TAG_ID = "tag_id";
    private static final String FIELD_SEX = "sex";
    private static final String FIELD_COUNTRY = "country";
    private static final String FIELD_PROVINCE = "province";
    private static final String FIELD_CITY = "city";
    private static final String FIELD_CLIENT_PLATFORM_TYPE = "client_platform_type";
    private static final String FIELD_LANGUAGE = "language";

    public JsonElement serialize(WxMenu menu, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        JsonArray buttonArray = new JsonArray();
        Optional.ofNullable(menu.getButtons()).ifPresent(buttons -> buttons.stream().map(this::convertToJson).forEach(arg_0 -> ((JsonArray)buttonArray).add(arg_0)));
        json.add(FIELD_BUTTON, (JsonElement)buttonArray);
        if (menu.getMatchRule() != null) {
            json.add(FIELD_MATCH_RULE, (JsonElement)this.convertToJson(menu.getMatchRule()));
        }
        return json;
    }

    protected JsonObject convertToJson(WxMenuButton button) {
        JsonObject buttonJson = new JsonObject();
        this.addPropertyIfNotNull(buttonJson, FIELD_TYPE, button.getType());
        this.addPropertyIfNotNull(buttonJson, FIELD_NAME, button.getName());
        this.addPropertyIfNotNull(buttonJson, FIELD_KEY, button.getKey());
        this.addPropertyIfNotNull(buttonJson, FIELD_URL, button.getUrl());
        this.addPropertyIfNotNull(buttonJson, FIELD_MEDIA_ID, button.getMediaId());
        this.addPropertyIfNotNull(buttonJson, FIELD_ARTICLE_ID, button.getArticleId());
        this.addPropertyIfNotNull(buttonJson, FIELD_APP_ID, button.getAppId());
        this.addPropertyIfNotNull(buttonJson, FIELD_PAGE_PATH, button.getPagePath());
        if (button.getSubButtons() != null && !button.getSubButtons().isEmpty()) {
            JsonArray buttonArray = new JsonArray();
            button.getSubButtons().stream().map(this::convertToJson).forEach(arg_0 -> ((JsonArray)buttonArray).add(arg_0));
            buttonJson.add(FIELD_SUB_BUTTON, (JsonElement)buttonArray);
        }
        return buttonJson;
    }

    protected JsonObject convertToJson(WxMenuRule menuRule) {
        JsonObject matchRule = new JsonObject();
        this.addPropertyIfNotNull(matchRule, FIELD_TAG_ID, menuRule.getTagId());
        this.addPropertyIfNotNull(matchRule, FIELD_SEX, menuRule.getSex());
        this.addPropertyIfNotNull(matchRule, FIELD_COUNTRY, menuRule.getCountry());
        this.addPropertyIfNotNull(matchRule, FIELD_PROVINCE, menuRule.getProvince());
        this.addPropertyIfNotNull(matchRule, FIELD_CITY, menuRule.getCity());
        this.addPropertyIfNotNull(matchRule, FIELD_CLIENT_PLATFORM_TYPE, menuRule.getClientPlatformType());
        this.addPropertyIfNotNull(matchRule, FIELD_LANGUAGE, menuRule.getLanguage());
        return matchRule;
    }

    private void addPropertyIfNotNull(JsonObject obj, String key, String value) {
        if (value != null) {
            obj.addProperty(key, value);
        }
    }

    public WxMenu deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject root = json.getAsJsonObject();
        JsonArray buttonsJson = null;
        if (root.has(FIELD_MENU)) {
            JsonObject menuObj = root.getAsJsonObject(FIELD_MENU);
            buttonsJson = menuObj.getAsJsonArray(FIELD_BUTTON);
        } else if (root.has(FIELD_BUTTON)) {
            buttonsJson = root.getAsJsonArray(FIELD_BUTTON);
        }
        if (buttonsJson == null) {
            throw new JsonParseException("No button array found in menu JSON");
        }
        return this.buildMenuFromJson(buttonsJson);
    }

    protected WxMenu buildMenuFromJson(JsonArray buttonsJson) {
        WxMenu menu = new WxMenu();
        for (JsonElement btnElem : buttonsJson) {
            JsonObject buttonJson = btnElem.getAsJsonObject();
            WxMenuButton button = this.convertFromJson(buttonJson);
            menu.getButtons().add(button);
            if (!buttonJson.has(FIELD_SUB_BUTTON) || !buttonJson.get(FIELD_SUB_BUTTON).isJsonArray()) continue;
            JsonArray sub_buttonsJson = buttonJson.getAsJsonArray(FIELD_SUB_BUTTON);
            for (JsonElement subBtnElem : sub_buttonsJson) {
                button.getSubButtons().add(this.convertFromJson(subBtnElem.getAsJsonObject()));
            }
        }
        return menu;
    }

    protected WxMenuButton convertFromJson(JsonObject json) {
        WxMenuButton button = new WxMenuButton();
        button.setName(GsonHelper.getString(json, FIELD_NAME));
        button.setKey(GsonHelper.getString(json, FIELD_KEY));
        button.setUrl(GsonHelper.getString(json, FIELD_URL));
        button.setType(GsonHelper.getString(json, FIELD_TYPE));
        button.setMediaId(GsonHelper.getString(json, FIELD_MEDIA_ID));
        button.setArticleId(GsonHelper.getString(json, FIELD_ARTICLE_ID));
        button.setAppId(GsonHelper.getString(json, FIELD_APP_ID));
        button.setPagePath(GsonHelper.getString(json, FIELD_PAGE_PATH));
        return button;
    }
}

