/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.util.requestexecuter.material;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import jodd.http.HttpConnectionProvider;
import jodd.http.HttpRequest;
import jodd.http.HttpResponse;
import jodd.http.ProxyInfo;
import me.chanjar.weixin.common.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;
import me.chanjar.weixin.mp.bean.material.WxMpMaterial;
import me.chanjar.weixin.mp.bean.material.WxMpMaterialUploadResult;
import me.chanjar.weixin.mp.util.requestexecuter.material.MaterialUploadRequestExecutor;

public class MaterialUploadJoddHttpRequestExecutor
extends MaterialUploadRequestExecutor<HttpConnectionProvider, ProxyInfo> {
    public MaterialUploadJoddHttpRequestExecutor(RequestHttp requestHttp) {
        super(requestHttp);
    }

    public WxMpMaterialUploadResult execute(String uri, WxMpMaterial material) throws WxErrorException, IOException {
        HttpRequest request = HttpRequest.post((String)uri);
        if (this.requestHttp.getRequestHttpProxy() != null) {
            ((HttpConnectionProvider)this.requestHttp.getRequestHttpClient()).useProxy((ProxyInfo)this.requestHttp.getRequestHttpProxy());
        }
        request.withConnectionProvider((HttpConnectionProvider)this.requestHttp.getRequestHttpClient());
        if (material == null) {
            throw new WxErrorException(WxError.builder().errorCode(-1).errorMsg("\u975e\u6cd5\u8bf7\u6c42\uff0cmaterial\u53c2\u6570\u4e3a\u7a7a").build());
        }
        File file = material.getFile();
        if (file == null || !file.exists()) {
            throw new FileNotFoundException();
        }
        request.form("media", (Object)file);
        Map<String, String> form = material.getForm();
        if (material.getForm() != null) {
            request.form("description", (Object)WxGsonBuilder.create().toJson(form));
        }
        HttpResponse response = request.send();
        response.charset("UTF-8");
        String responseContent = response.bodyText();
        WxError error = WxError.fromJson((String)responseContent, (WxType)WxType.MP);
        if (error.getErrorCode() != 0) {
            throw new WxErrorException(error);
        }
        return WxMpMaterialUploadResult.fromJson(responseContent);
    }
}

